# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.descriptive_statistics import DescriptiveStatistics


class PDescriptiveStatistics(DescriptiveStatistics):
    r"""
    PDescriptiveStatistics - A class for parallel univariate
    descriptive statistics
    
    Superclass: DescriptiveStatistics
    
    PDescriptiveStatistics is DescriptiveStatistics subclass for
    parallel datasets. It learns and derives the global statistical model
    on each node, but assesses each individual data points on the node
    that owns it.
    
    ote Kurtosis formula in "Formulas for robust, one-pass parallel
    computation of covariances and Arbitrary-Order Statistical Moments",
    P. Pébay, 2008,  has an error (equation 1.6 in the paper). A correct
    formula can be found in "Formulas for the Computation of Higher-
    Order Central Moments", P. Pébay, T.B. Terriberry, H. Kolla, J.
    Bennett, 2016, at equation 3.6. The latter one is being used to
    compute the 4th moment from partial ones across ranks.
    
    @par Thanks: Thanks to Philippe Pebay from Sandia National
    Laboratories for implementing this class.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPDescriptiveStatistics, obj, update, **traits)
    
    def _get_controller(self):
        return wrap_vtk(self._vtk_obj.GetController())
    def _set_controller(self, arg):
        old_val = self._get_controller()
        self._wrap_call(self._vtk_obj.SetController,
                        deref_vtk(arg))
        self.trait_property_changed('controller', old_val, arg)
    controller = traits.Property(_get_controller, _set_controller, desc=\
        r"""
        
        """
    )

    def learn(self, *args):
        """
        learn(self, inData:Table, inParameters:Table,
            outMeta:MultiBlockDataSet) -> None
        C++: void learn(Table *inData, Table *inParameters,
            MultiBlockDataSet *outMeta) override;
        Execute the parallel calculations required by the Learn option.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Learn, *my_args)
        return ret

    _updateable_traits_ = \
    (('g1_skewness', 'GetG1Skewness'), ('g2_kurtosis', 'GetG2Kurtosis'),
    ('sample_estimate', 'GetSampleEstimate'), ('signed_deviations',
    'GetSignedDeviations'), ('unbiased_variance', 'GetUnbiasedVariance'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('ghosts_to_skip', 'GetGhostsToSkip'), ('assess_option',
    'GetAssessOption'), ('derive_option', 'GetDeriveOption'),
    ('learn_option', 'GetLearnOption'), ('number_of_primary_tables',
    'GetNumberOfPrimaryTables'), ('test_option', 'GetTestOption'),
    ('progress_text', 'GetProgressText'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'g1_skewness', 'g2_kurtosis',
    'global_warning_display', 'release_data_flag', 'sample_estimate',
    'signed_deviations', 'unbiased_variance', 'assess_option',
    'derive_option', 'ghosts_to_skip', 'learn_option',
    'number_of_primary_tables', 'object_name', 'progress_text',
    'test_option'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PDescriptiveStatistics, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PDescriptiveStatistics properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['g1_skewness', 'g2_kurtosis', 'sample_estimate',
            'signed_deviations', 'unbiased_variance'], [], ['assess_option',
            'derive_option', 'ghosts_to_skip', 'learn_option',
            'number_of_primary_tables', 'object_name', 'test_option']),
            title='Edit PDescriptiveStatistics properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PDescriptiveStatistics properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

