# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.writer import Writer


class STLWriter(Writer):
    r"""
    STLWriter - write stereo lithography files
    
    Superclass: Writer
    
    STLWriter writes stereo lithography (.stl) files in either ASCII
    or binary form. Stereo lithography files contain only triangles.
    Since VTK 8.1, this writer converts non-triangle polygons into
    triangles, so there is no longer a need to use TriangleFilter
    prior to using this writer if the input contains polygons with more
    than three vertices.
    
    @warning
    Binary files written on one system may not be readable on other
    systems. STLWriter uses VAX or PC byte ordering and swaps bytes on
    other systems.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkSTLWriter, obj, update, **traits)
    
    file_type = tvtk_base.RevPrefixMap({'ascii': 1, 'binary': 2}, default_value='ascii', desc=\
        r"""
        Specify file type (ASCII or BINARY) for vtk data file.
        """
    )

    def _file_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileType,
                        self.file_type_)

    def _get_binary_header(self):
        return wrap_vtk(self._vtk_obj.GetBinaryHeader())
    def _set_binary_header(self, arg):
        old_val = self._get_binary_header()
        my_arg = deref_array([arg], [['vtkUnsignedCharArray']])
        self._wrap_call(self._vtk_obj.SetBinaryHeader,
                        my_arg[0])
        self.trait_property_changed('binary_header', old_val, arg)
    binary_header = traits.Property(_get_binary_header, _set_binary_header, desc=\
        r"""
        
        """
    )

    file_name = tvtk_base.vtk_file_name("", desc=\
        r"""
        Specify file name of vtk polygon data file to write.
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    header = traits.String('Visualization Toolkit generated SLA File', enter_set=True, auto_set=False, desc=\
        r"""
        Set the header for the file as text. The header cannot contain
        0x00 characters.
        \sa set_binary_header()
        """
    )

    def _header_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHeader,
                        self.header)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> PolyData
        C++: PolyData *get_input()
        get_input(self, port:int) -> PolyData
        C++: PolyData *get_input(int port)
        Get the input to this writer.
        """
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('file_type',
    'GetFileType'), ('file_name', 'GetFileName'), ('header', 'GetHeader'),
    ('progress_text', 'GetProgressText'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'file_type', 'file_name', 'header',
    'object_name', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(STLWriter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit STLWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], ['file_type'], ['file_name', 'header', 'object_name']),
            title='Edit STLWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit STLWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

