// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IntSurf_PntOn2S_HeaderFile
#define _IntSurf_PntOn2S_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <gp_Pnt.hxx>
#include <Standard_Real.hxx>
#include <Standard_Boolean.hxx>
class gp_Pnt;


//! This class defines the geometric informations
//! for an intersection point between 2 surfaces :
//! The coordinates ( Pnt from gp ), and two
//! parametric coordinates.
class IntSurf_PntOn2S 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Empty constructor.
  Standard_EXPORT IntSurf_PntOn2S();
  
  //! Sets the value of the point in 3d space.
      void SetValue (const gp_Pnt& Pt) ;
  
  //! Sets the values of the point in 3d space, and
  //! in the parametric space of one of the surface.
  Standard_EXPORT   void SetValue (const gp_Pnt& Pt, const Standard_Boolean OnFirst, const Standard_Real U, const Standard_Real V) ;
  
  //! Sets the values of the point in 3d space, and
  //! in the parametric space of each surface.
      void SetValue (const gp_Pnt& Pt, const Standard_Real U1, const Standard_Real V1, const Standard_Real U2, const Standard_Real V2) ;
  
  //! Set the values of the point in the parametric
  //! space of one of the surface.
  Standard_EXPORT   void SetValue (const Standard_Boolean OnFirst, const Standard_Real U, const Standard_Real V) ;
  
  //! Set the values of the point in the parametric
  //! space of one of the surface.
      void SetValue (const Standard_Real U1, const Standard_Real V1, const Standard_Real U2, const Standard_Real V2) ;
  
  //! Returns the point in 3d space.
     const  gp_Pnt& Value()  const;
  
  //! Returns the parameters of the point on the first surface.
      void ParametersOnS1 (Standard_Real& U1, Standard_Real& V1)  const;
  
  //! Returns the parameters of the point on the second surface.
      void ParametersOnS2 (Standard_Real& U2, Standard_Real& V2)  const;
  
  //! Returns the parameters of the point on both surfaces.
      void Parameters (Standard_Real& U1, Standard_Real& V1, Standard_Real& U2, Standard_Real& V2)  const;
  
  //! Returns TRUE if 2D- and 3D-coordinates of theOterPoint are equal to
  //! corresponding coordinates of me (with given tolerance).
  //! If theTol2D == 0.0 we will compare 3D-points only.
  Standard_EXPORT   Standard_Boolean IsSame (const IntSurf_PntOn2S& theOterPoint, const Standard_Real theTol3D = 0.0, const Standard_Real theTol2D = 0.0)  const;




protected:





private:



  gp_Pnt pt;
  Standard_Real u1;
  Standard_Real v1;
  Standard_Real u2;
  Standard_Real v2;


};


#include <IntSurf_PntOn2S.lxx>





#endif // _IntSurf_PntOn2S_HeaderFile
