#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""Tests for Tango on Android databases event formatter."""

from __future__ import unicode_literals

import unittest

from plaso.formatters import tango_android
from tests.formatters import test_lib


class TangoAndroidContactFormatterTest(test_lib.EventFormatterTestCase):
  """Tests the Tango on Android contact event formatter."""

  def testInitialization(self):
    """Tests the initialization."""
    event_formatter = tango_android.TangoAndroidContactFormatter()
    self.assertIsNotNone(event_formatter)

  def testGetFormatStringAttributeNames(self):
    """Tests the GetFormatStringAttributeNames function."""
    event_formatter = tango_android.TangoAndroidContactFormatter()

    expected_attribute_names = [
        'first_name',
        'last_name',
        'gender',
        'birthday',
        'status',
        'is_friend',
        'friend_request_type',
        'friend_request_message'
    ]

    self._TestGetFormatStringAttributeNames(
        event_formatter, expected_attribute_names)


if __name__ == '__main__':
  unittest.main()
