# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class GraphParameter(Model):
    """Defines a global parameter in the graph.

    :param description: Description of this graph parameter.
    :type description: str
    :param type: Graph parameter's type. Possible values include: 'String',
     'Int', 'Float', 'Enumerated', 'Script', 'Mode', 'Credential', 'Boolean',
     'Double', 'ColumnPicker', 'ParameterRange', 'DataGatewayName'
    :type type: str or :class:`ParameterType
     <azure.mgmt.machinelearning.models.ParameterType>`
    :param links: Association links for this parameter to nodes in the graph.
    :type links: list of :class:`GraphParameterLink
     <azure.mgmt.machinelearning.models.GraphParameterLink>`
    """

    _validation = {
        'type': {'required': True},
        'links': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'links': {'key': 'links', 'type': '[GraphParameterLink]'},
    }

    def __init__(self, type, links, description=None):
        self.description = description
        self.type = type
        self.links = links
