# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._azure_bot_service_enums import *


class Channel(msrest.serialization.Model):
    """Channel definition.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AlexaChannel, DirectLineChannel, DirectLineSpeechChannel, EmailChannel, FacebookChannel, KikChannel, LineChannel, MsTeamsChannel, SkypeChannel, SlackChannel, SmsChannel, TelegramChannel, WebChatChannel.

    All required parameters must be populated in order to send to Azure.

    :param channel_name: Required. The channel name.Constant filled by server.
    :type channel_name: str
    """

    _validation = {
        'channel_name': {'required': True},
    }

    _attribute_map = {
        'channel_name': {'key': 'channelName', 'type': 'str'},
    }

    _subtype_map = {
        'channel_name': {'AlexaChannel': 'AlexaChannel', 'DirectLineChannel': 'DirectLineChannel', 'DirectLineSpeechChannel': 'DirectLineSpeechChannel', 'EmailChannel': 'EmailChannel', 'FacebookChannel': 'FacebookChannel', 'KikChannel': 'KikChannel', 'LineChannel': 'LineChannel', 'MsTeamsChannel': 'MsTeamsChannel', 'SkypeChannel': 'SkypeChannel', 'SlackChannel': 'SlackChannel', 'SmsChannel': 'SmsChannel', 'TelegramChannel': 'TelegramChannel', 'WebChatChannel': 'WebChatChannel'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Channel, self).__init__(**kwargs)
        self.channel_name = None  # type: Optional[str]


class AlexaChannel(Channel):
    """Alexa channel definition.

    All required parameters must be populated in order to send to Azure.

    :param channel_name: Required. The channel name.Constant filled by server.
    :type channel_name: str
    :param properties: The set of properties specific to Alexa channel resource.
    :type properties: ~azure.mgmt.botservice.models.AlexaChannelProperties
    """

    _validation = {
        'channel_name': {'required': True},
    }

    _attribute_map = {
        'channel_name': {'key': 'channelName', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'AlexaChannelProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["AlexaChannelProperties"] = None,
        **kwargs
    ):
        super(AlexaChannel, self).__init__(**kwargs)
        self.channel_name = 'AlexaChannel'  # type: str
        self.properties = properties


class AlexaChannelProperties(msrest.serialization.Model):
    """The parameters to provide for the Alexa channel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param alexa_skill_id: Required. The Alexa skill Id.
    :type alexa_skill_id: str
    :ivar url_fragment: Url fragment used in part of the Uri configured in Alexa.
    :vartype url_fragment: str
    :ivar service_endpoint_uri: Full Uri used to configured the skill in Alexa.
    :vartype service_endpoint_uri: str
    :param is_enabled: Required. Whether this channel is enabled for the bot.
    :type is_enabled: bool
    """

    _validation = {
        'alexa_skill_id': {'required': True},
        'url_fragment': {'readonly': True},
        'service_endpoint_uri': {'readonly': True},
        'is_enabled': {'required': True},
    }

    _attribute_map = {
        'alexa_skill_id': {'key': 'alexaSkillId', 'type': 'str'},
        'url_fragment': {'key': 'urlFragment', 'type': 'str'},
        'service_endpoint_uri': {'key': 'serviceEndpointUri', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        alexa_skill_id: str,
        is_enabled: bool,
        **kwargs
    ):
        super(AlexaChannelProperties, self).__init__(**kwargs)
        self.alexa_skill_id = alexa_skill_id
        self.url_fragment = None
        self.service_endpoint_uri = None
        self.is_enabled = is_enabled


class Resource(msrest.serialization.Model):
    """Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Specifies the resource ID.
    :vartype id: str
    :ivar name: Specifies the name of the resource.
    :vartype name: str
    :param location: Specifies the location of the resource.
    :type location: str
    :ivar type: Specifies the type of the resource.
    :vartype type: str
    :param tags: A set of tags. Contains resource tags defined as key/value pairs.
    :type tags: dict[str, str]
    :param sku: Gets or sets the SKU of the resource.
    :type sku: ~azure.mgmt.botservice.models.Sku
    :param kind: Required. Gets or sets the Kind of the resource. Possible values include: "sdk",
     "designer", "bot", "function", "azurebot".
    :type kind: str or ~azure.mgmt.botservice.models.Kind
    :param etag: Entity Tag.
    :type etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'kind': {'key': 'kind', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        kind: Optional[Union[str, "Kind"]] = None,
        etag: Optional[str] = None,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.location = location
        self.type = None
        self.tags = tags
        self.sku = sku
        self.kind = kind
        self.etag = etag


class Bot(Resource):
    """Bot resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Specifies the resource ID.
    :vartype id: str
    :ivar name: Specifies the name of the resource.
    :vartype name: str
    :param location: Specifies the location of the resource.
    :type location: str
    :ivar type: Specifies the type of the resource.
    :vartype type: str
    :param tags: A set of tags. Contains resource tags defined as key/value pairs.
    :type tags: dict[str, str]
    :param sku: Gets or sets the SKU of the resource.
    :type sku: ~azure.mgmt.botservice.models.Sku
    :param kind: Required. Gets or sets the Kind of the resource. Possible values include: "sdk",
     "designer", "bot", "function", "azurebot".
    :type kind: str or ~azure.mgmt.botservice.models.Kind
    :param etag: Entity Tag.
    :type etag: str
    :param properties: The set of properties specific to bot resource.
    :type properties: ~azure.mgmt.botservice.models.BotProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'kind': {'key': 'kind', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'BotProperties'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        kind: Optional[Union[str, "Kind"]] = None,
        etag: Optional[str] = None,
        properties: Optional["BotProperties"] = None,
        **kwargs
    ):
        super(Bot, self).__init__(location=location, tags=tags, sku=sku, kind=kind, etag=etag, **kwargs)
        self.properties = properties


class BotChannel(Resource):
    """Bot channel resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Specifies the resource ID.
    :vartype id: str
    :ivar name: Specifies the name of the resource.
    :vartype name: str
    :param location: Specifies the location of the resource.
    :type location: str
    :ivar type: Specifies the type of the resource.
    :vartype type: str
    :param tags: A set of tags. Contains resource tags defined as key/value pairs.
    :type tags: dict[str, str]
    :param sku: Gets or sets the SKU of the resource.
    :type sku: ~azure.mgmt.botservice.models.Sku
    :param kind: Required. Gets or sets the Kind of the resource. Possible values include: "sdk",
     "designer", "bot", "function", "azurebot".
    :type kind: str or ~azure.mgmt.botservice.models.Kind
    :param etag: Entity Tag.
    :type etag: str
    :param properties: The set of properties specific to bot channel resource.
    :type properties: ~azure.mgmt.botservice.models.Channel
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'kind': {'key': 'kind', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'Channel'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        kind: Optional[Union[str, "Kind"]] = None,
        etag: Optional[str] = None,
        properties: Optional["Channel"] = None,
        **kwargs
    ):
        super(BotChannel, self).__init__(location=location, tags=tags, sku=sku, kind=kind, etag=etag, **kwargs)
        self.properties = properties


class BotProperties(msrest.serialization.Model):
    """The parameters to provide for the Bot.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param display_name: Required. The Name of the bot.
    :type display_name: str
    :param description: The description of the bot.
    :type description: str
    :param icon_url: The Icon Url of the bot.
    :type icon_url: str
    :param endpoint: Required. The bot's endpoint.
    :type endpoint: str
    :ivar endpoint_version: The bot's endpoint version.
    :vartype endpoint_version: str
    :param msa_app_id: Required. Microsoft App Id for the bot.
    :type msa_app_id: str
    :ivar configured_channels: Collection of channels for which the bot is configured.
    :vartype configured_channels: list[str]
    :ivar enabled_channels: Collection of channels for which the bot is enabled.
    :vartype enabled_channels: list[str]
    :param developer_app_insight_key: The Application Insights key.
    :type developer_app_insight_key: str
    :param developer_app_insights_api_key: The Application Insights Api Key.
    :type developer_app_insights_api_key: str
    :param developer_app_insights_application_id: The Application Insights App Id.
    :type developer_app_insights_application_id: str
    :param luis_app_ids: Collection of LUIS App Ids.
    :type luis_app_ids: list[str]
    :param luis_key: The LUIS Key.
    :type luis_key: str
    :param is_cmek_enabled: Whether Cmek is enabled.
    :type is_cmek_enabled: bool
    :param cmek_key_vault_url: The CMK Url.
    :type cmek_key_vault_url: str
    :param is_isolated: Whether the bot is in an isolated network.
    :type is_isolated: bool
    :param schema_transformation_version: The channel schema transformation version for the bot.
    :type schema_transformation_version: str
    """

    _validation = {
        'display_name': {'required': True},
        'endpoint': {'required': True},
        'endpoint_version': {'readonly': True},
        'msa_app_id': {'required': True},
        'configured_channels': {'readonly': True},
        'enabled_channels': {'readonly': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'icon_url': {'key': 'iconUrl', 'type': 'str'},
        'endpoint': {'key': 'endpoint', 'type': 'str'},
        'endpoint_version': {'key': 'endpointVersion', 'type': 'str'},
        'msa_app_id': {'key': 'msaAppId', 'type': 'str'},
        'configured_channels': {'key': 'configuredChannels', 'type': '[str]'},
        'enabled_channels': {'key': 'enabledChannels', 'type': '[str]'},
        'developer_app_insight_key': {'key': 'developerAppInsightKey', 'type': 'str'},
        'developer_app_insights_api_key': {'key': 'developerAppInsightsApiKey', 'type': 'str'},
        'developer_app_insights_application_id': {'key': 'developerAppInsightsApplicationId', 'type': 'str'},
        'luis_app_ids': {'key': 'luisAppIds', 'type': '[str]'},
        'luis_key': {'key': 'luisKey', 'type': 'str'},
        'is_cmek_enabled': {'key': 'isCmekEnabled', 'type': 'bool'},
        'cmek_key_vault_url': {'key': 'cmekKeyVaultUrl', 'type': 'str'},
        'is_isolated': {'key': 'isIsolated', 'type': 'bool'},
        'schema_transformation_version': {'key': 'schemaTransformationVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display_name: str,
        endpoint: str,
        msa_app_id: str,
        description: Optional[str] = None,
        icon_url: Optional[str] = None,
        developer_app_insight_key: Optional[str] = None,
        developer_app_insights_api_key: Optional[str] = None,
        developer_app_insights_application_id: Optional[str] = None,
        luis_app_ids: Optional[List[str]] = None,
        luis_key: Optional[str] = None,
        is_cmek_enabled: Optional[bool] = None,
        cmek_key_vault_url: Optional[str] = None,
        is_isolated: Optional[bool] = None,
        schema_transformation_version: Optional[str] = None,
        **kwargs
    ):
        super(BotProperties, self).__init__(**kwargs)
        self.display_name = display_name
        self.description = description
        self.icon_url = icon_url
        self.endpoint = endpoint
        self.endpoint_version = None
        self.msa_app_id = msa_app_id
        self.configured_channels = None
        self.enabled_channels = None
        self.developer_app_insight_key = developer_app_insight_key
        self.developer_app_insights_api_key = developer_app_insights_api_key
        self.developer_app_insights_application_id = developer_app_insights_application_id
        self.luis_app_ids = luis_app_ids
        self.luis_key = luis_key
        self.is_cmek_enabled = is_cmek_enabled
        self.cmek_key_vault_url = cmek_key_vault_url
        self.is_isolated = is_isolated
        self.schema_transformation_version = schema_transformation_version


class BotResponseList(msrest.serialization.Model):
    """The list of  bot service operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param next_link: The link used to get the next page of bot service resources.
    :type next_link: str
    :ivar value: Gets the list of bot service results and their properties.
    :vartype value: list[~azure.mgmt.botservice.models.Bot]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Bot]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(BotResponseList, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = None


class ChannelResponseList(msrest.serialization.Model):
    """The list of bot service channel operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param next_link: The link used to get the next page of bot service channel resources.
    :type next_link: str
    :ivar value: Gets the list of bot service channel results and their properties.
    :vartype value: list[~azure.mgmt.botservice.models.BotChannel]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[BotChannel]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ChannelResponseList, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = None


class CheckNameAvailabilityRequestBody(msrest.serialization.Model):
    """The request body for a request to Bot Service Management to check availability of a bot name.

    :param name: the name of the bot for which availability needs to be checked.
    :type name: str
    :param type: the type of the bot for which availability needs to be checked.
    :type type: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs
    ):
        super(CheckNameAvailabilityRequestBody, self).__init__(**kwargs)
        self.name = name
        self.type = type


class CheckNameAvailabilityResponseBody(msrest.serialization.Model):
    """The response body returned for a request to Bot Service Management to check availability of a bot name.

    :param valid: indicates if the bot name is valid.
    :type valid: bool
    :param message: additional message from the bot management api showing why a bot name is not
     available.
    :type message: str
    """

    _attribute_map = {
        'valid': {'key': 'valid', 'type': 'bool'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        valid: Optional[bool] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(CheckNameAvailabilityResponseBody, self).__init__(**kwargs)
        self.valid = valid
        self.message = message


class ConnectionItemName(msrest.serialization.Model):
    """The display name of a connection Item Setting registered with the Bot.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Connection Item name that has been added in the API.
    :vartype name: str
    """

    _validation = {
        'name': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectionItemName, self).__init__(**kwargs)
        self.name = None


class ConnectionSetting(Resource):
    """Bot channel resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Specifies the resource ID.
    :vartype id: str
    :ivar name: Specifies the name of the resource.
    :vartype name: str
    :param location: Specifies the location of the resource.
    :type location: str
    :ivar type: Specifies the type of the resource.
    :vartype type: str
    :param tags: A set of tags. Contains resource tags defined as key/value pairs.
    :type tags: dict[str, str]
    :param sku: Gets or sets the SKU of the resource.
    :type sku: ~azure.mgmt.botservice.models.Sku
    :param kind: Required. Gets or sets the Kind of the resource. Possible values include: "sdk",
     "designer", "bot", "function", "azurebot".
    :type kind: str or ~azure.mgmt.botservice.models.Kind
    :param etag: Entity Tag.
    :type etag: str
    :param properties: The set of properties specific to bot channel resource.
    :type properties: ~azure.mgmt.botservice.models.ConnectionSettingProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'kind': {'key': 'kind', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ConnectionSettingProperties'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        kind: Optional[Union[str, "Kind"]] = None,
        etag: Optional[str] = None,
        properties: Optional["ConnectionSettingProperties"] = None,
        **kwargs
    ):
        super(ConnectionSetting, self).__init__(location=location, tags=tags, sku=sku, kind=kind, etag=etag, **kwargs)
        self.properties = properties


class ConnectionSettingParameter(msrest.serialization.Model):
    """Extra Parameter in a Connection Setting Properties to indicate service provider specific properties.

    :param key: Key for the Connection Setting Parameter.
    :type key: str
    :param value: Value associated with the Connection Setting Parameter.
    :type value: str
    """

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        super(ConnectionSettingParameter, self).__init__(**kwargs)
        self.key = key
        self.value = value


class ConnectionSettingProperties(msrest.serialization.Model):
    """Properties for a Connection Setting Item.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param client_id: Client Id associated with the Connection Setting.
    :type client_id: str
    :ivar setting_id: Setting Id set by the service for the Connection Setting.
    :vartype setting_id: str
    :param client_secret: Client Secret associated with the Connection Setting.
    :type client_secret: str
    :param scopes: Scopes associated with the Connection Setting.
    :type scopes: str
    :param service_provider_id: Service Provider Id associated with the Connection Setting.
    :type service_provider_id: str
    :param service_provider_display_name: Service Provider Display Name associated with the
     Connection Setting.
    :type service_provider_display_name: str
    :param parameters: Service Provider Parameters associated with the Connection Setting.
    :type parameters: list[~azure.mgmt.botservice.models.ConnectionSettingParameter]
    """

    _validation = {
        'setting_id': {'readonly': True},
    }

    _attribute_map = {
        'client_id': {'key': 'clientId', 'type': 'str'},
        'setting_id': {'key': 'settingId', 'type': 'str'},
        'client_secret': {'key': 'clientSecret', 'type': 'str'},
        'scopes': {'key': 'scopes', 'type': 'str'},
        'service_provider_id': {'key': 'serviceProviderId', 'type': 'str'},
        'service_provider_display_name': {'key': 'serviceProviderDisplayName', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '[ConnectionSettingParameter]'},
    }

    def __init__(
        self,
        *,
        client_id: Optional[str] = None,
        client_secret: Optional[str] = None,
        scopes: Optional[str] = None,
        service_provider_id: Optional[str] = None,
        service_provider_display_name: Optional[str] = None,
        parameters: Optional[List["ConnectionSettingParameter"]] = None,
        **kwargs
    ):
        super(ConnectionSettingProperties, self).__init__(**kwargs)
        self.client_id = client_id
        self.setting_id = None
        self.client_secret = client_secret
        self.scopes = scopes
        self.service_provider_id = service_provider_id
        self.service_provider_display_name = service_provider_display_name
        self.parameters = parameters


class ConnectionSettingResponseList(msrest.serialization.Model):
    """The list of bot service connection settings response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param next_link: The link used to get the next page of bot service connection setting
     resources.
    :type next_link: str
    :ivar value: Gets the list of bot service connection settings and their properties.
    :vartype value: list[~azure.mgmt.botservice.models.ConnectionSetting]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[ConnectionSetting]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ConnectionSettingResponseList, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = None


class DirectLineChannel(Channel):
    """Direct Line channel definition.

    All required parameters must be populated in order to send to Azure.

    :param channel_name: Required. The channel name.Constant filled by server.
    :type channel_name: str
    :param properties: The set of properties specific to Direct Line channel resource.
    :type properties: ~azure.mgmt.botservice.models.DirectLineChannelProperties
    """

    _validation = {
        'channel_name': {'required': True},
    }

    _attribute_map = {
        'channel_name': {'key': 'channelName', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'DirectLineChannelProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["DirectLineChannelProperties"] = None,
        **kwargs
    ):
        super(DirectLineChannel, self).__init__(**kwargs)
        self.channel_name = 'DirectLineChannel'  # type: str
        self.properties = properties


class DirectLineChannelProperties(msrest.serialization.Model):
    """The parameters to provide for the Direct Line channel.

    :param sites: The list of Direct Line sites.
    :type sites: list[~azure.mgmt.botservice.models.DirectLineSite]
    """

    _attribute_map = {
        'sites': {'key': 'sites', 'type': '[DirectLineSite]'},
    }

    def __init__(
        self,
        *,
        sites: Optional[List["DirectLineSite"]] = None,
        **kwargs
    ):
        super(DirectLineChannelProperties, self).__init__(**kwargs)
        self.sites = sites


class DirectLineSite(msrest.serialization.Model):
    """A site for the Direct Line channel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar site_id: Site Id.
    :vartype site_id: str
    :param site_name: Required. Site name.
    :type site_name: str
    :ivar key: Primary key. Value only returned through POST to the action Channel List API,
     otherwise empty.
    :vartype key: str
    :ivar key2: Secondary key. Value only returned through POST to the action Channel List API,
     otherwise empty.
    :vartype key2: str
    :param is_enabled: Required. Whether this site is enabled for DirectLine channel.
    :type is_enabled: bool
    :param is_v1_enabled: Required. Whether this site is enabled for Bot Framework V1 protocol.
    :type is_v1_enabled: bool
    :param is_v3_enabled: Required. Whether this site is enabled for Bot Framework V1 protocol.
    :type is_v3_enabled: bool
    :param is_secure_site_enabled: Whether this site is enabled for authentication with Bot
     Framework.
    :type is_secure_site_enabled: bool
    :param trusted_origins: List of Trusted Origin URLs for this site. This field is applicable
     only if isSecureSiteEnabled is True.
    :type trusted_origins: list[str]
    """

    _validation = {
        'site_id': {'readonly': True},
        'site_name': {'required': True},
        'key': {'readonly': True},
        'key2': {'readonly': True},
        'is_enabled': {'required': True},
        'is_v1_enabled': {'required': True},
        'is_v3_enabled': {'required': True},
    }

    _attribute_map = {
        'site_id': {'key': 'siteId', 'type': 'str'},
        'site_name': {'key': 'siteName', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'key2': {'key': 'key2', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'is_v1_enabled': {'key': 'isV1Enabled', 'type': 'bool'},
        'is_v3_enabled': {'key': 'isV3Enabled', 'type': 'bool'},
        'is_secure_site_enabled': {'key': 'isSecureSiteEnabled', 'type': 'bool'},
        'trusted_origins': {'key': 'trustedOrigins', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        site_name: str,
        is_enabled: bool,
        is_v1_enabled: bool,
        is_v3_enabled: bool,
        is_secure_site_enabled: Optional[bool] = None,
        trusted_origins: Optional[List[str]] = None,
        **kwargs
    ):
        super(DirectLineSite, self).__init__(**kwargs)
        self.site_id = None
        self.site_name = site_name
        self.key = None
        self.key2 = None
        self.is_enabled = is_enabled
        self.is_v1_enabled = is_v1_enabled
        self.is_v3_enabled = is_v3_enabled
        self.is_secure_site_enabled = is_secure_site_enabled
        self.trusted_origins = trusted_origins


class DirectLineSpeechChannel(Channel):
    """DirectLine Speech channel definition.

    All required parameters must be populated in order to send to Azure.

    :param channel_name: Required. The channel name.Constant filled by server.
    :type channel_name: str
    :param properties: The set of properties specific to DirectLine Speech channel resource.
    :type properties: ~azure.mgmt.botservice.models.DirectLineSpeechChannelProperties
    """

    _validation = {
        'channel_name': {'required': True},
    }

    _attribute_map = {
        'channel_name': {'key': 'channelName', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'DirectLineSpeechChannelProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["DirectLineSpeechChannelProperties"] = None,
        **kwargs
    ):
        super(DirectLineSpeechChannel, self).__init__(**kwargs)
        self.channel_name = 'DirectLineSpeechChannel'  # type: str
        self.properties = properties


class DirectLineSpeechChannelProperties(msrest.serialization.Model):
    """The parameters to provide for the DirectLine Speech channel.

    All required parameters must be populated in order to send to Azure.

    :param cognitive_services_subscription_id: Required. The cognitive service subscription ID to
     use with this channel registration.
    :type cognitive_services_subscription_id: str
    :param is_enabled: Whether this channel is enabled or not.
    :type is_enabled: bool
    :param custom_voice_deployment_id: Custom speech model id (optional).
    :type custom_voice_deployment_id: str
    :param custom_speech_model_id: Custom voice deployment id (optional).
    :type custom_speech_model_id: str
    :param is_default_bot_for_cog_svc_account: Make this a default bot for chosen cognitive service
     account.
    :type is_default_bot_for_cog_svc_account: bool
    """

    _validation = {
        'cognitive_services_subscription_id': {'required': True},
    }

    _attribute_map = {
        'cognitive_services_subscription_id': {'key': 'cognitiveServicesSubscriptionId', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'custom_voice_deployment_id': {'key': 'customVoiceDeploymentId', 'type': 'str'},
        'custom_speech_model_id': {'key': 'customSpeechModelId', 'type': 'str'},
        'is_default_bot_for_cog_svc_account': {'key': 'isDefaultBotForCogSvcAccount', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        cognitive_services_subscription_id: str,
        is_enabled: Optional[bool] = None,
        custom_voice_deployment_id: Optional[str] = None,
        custom_speech_model_id: Optional[str] = None,
        is_default_bot_for_cog_svc_account: Optional[bool] = None,
        **kwargs
    ):
        super(DirectLineSpeechChannelProperties, self).__init__(**kwargs)
        self.cognitive_services_subscription_id = cognitive_services_subscription_id
        self.is_enabled = is_enabled
        self.custom_voice_deployment_id = custom_voice_deployment_id
        self.custom_speech_model_id = custom_speech_model_id
        self.is_default_bot_for_cog_svc_account = is_default_bot_for_cog_svc_account


class EmailChannel(Channel):
    """Email channel definition.

    All required parameters must be populated in order to send to Azure.

    :param channel_name: Required. The channel name.Constant filled by server.
    :type channel_name: str
    :param properties: The set of properties specific to email channel resource.
    :type properties: ~azure.mgmt.botservice.models.EmailChannelProperties
    """

    _validation = {
        'channel_name': {'required': True},
    }

    _attribute_map = {
        'channel_name': {'key': 'channelName', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'EmailChannelProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["EmailChannelProperties"] = None,
        **kwargs
    ):
        super(EmailChannel, self).__init__(**kwargs)
        self.channel_name = 'EmailChannel'  # type: str
        self.properties = properties


class EmailChannelProperties(msrest.serialization.Model):
    """The parameters to provide for the Email channel.

    All required parameters must be populated in order to send to Azure.

    :param email_address: Required. The email address.
    :type email_address: str
    :param password: The password for the email address. Value only returned through POST to the
     action Channel List API, otherwise empty.
    :type password: str
    :param is_enabled: Required. Whether this channel is enabled for the bot.
    :type is_enabled: bool
    """

    _validation = {
        'email_address': {'required': True},
        'is_enabled': {'required': True},
    }

    _attribute_map = {
        'email_address': {'key': 'emailAddress', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        email_address: str,
        is_enabled: bool,
        password: Optional[str] = None,
        **kwargs
    ):
        super(EmailChannelProperties, self).__init__(**kwargs)
        self.email_address = email_address
        self.password = password
        self.is_enabled = is_enabled


class Error(msrest.serialization.Model):
    """Bot Service error object.

    :param error: The error body.
    :type error: ~azure.mgmt.botservice.models.ErrorBody
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorBody'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorBody"] = None,
        **kwargs
    ):
        super(Error, self).__init__(**kwargs)
        self.error = error


class ErrorBody(msrest.serialization.Model):
    """Bot Service error body.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. error code.
    :type code: str
    :param message: Required. error message.
    :type message: str
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        **kwargs
    ):
        super(ErrorBody, self).__init__(**kwargs)
        self.code = code
        self.message = message


class FacebookChannel(Channel):
    """Facebook channel definition.

    All required parameters must be populated in order to send to Azure.

    :param channel_name: Required. The channel name.Constant filled by server.
    :type channel_name: str
    :param properties: The set of properties specific to bot facebook channel.
    :type properties: ~azure.mgmt.botservice.models.FacebookChannelProperties
    """

    _validation = {
        'channel_name': {'required': True},
    }

    _attribute_map = {
        'channel_name': {'key': 'channelName', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'FacebookChannelProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["FacebookChannelProperties"] = None,
        **kwargs
    ):
        super(FacebookChannel, self).__init__(**kwargs)
        self.channel_name = 'FacebookChannel'  # type: str
        self.properties = properties


class FacebookChannelProperties(msrest.serialization.Model):
    """The parameters to provide for the Facebook channel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar verify_token: Verify token. Value only returned through POST to the action Channel List
     API, otherwise empty.
    :vartype verify_token: str
    :param pages: The list of Facebook pages.
    :type pages: list[~azure.mgmt.botservice.models.FacebookPage]
    :param app_id: Required. Facebook application id.
    :type app_id: str
    :param app_secret: Facebook application secret. Value only returned through POST to the action
     Channel List API, otherwise empty.
    :type app_secret: str
    :ivar callback_url: Callback Url.
    :vartype callback_url: str
    :param is_enabled: Required. Whether this channel is enabled for the bot.
    :type is_enabled: bool
    """

    _validation = {
        'verify_token': {'readonly': True},
        'app_id': {'required': True},
        'callback_url': {'readonly': True},
        'is_enabled': {'required': True},
    }

    _attribute_map = {
        'verify_token': {'key': 'verifyToken', 'type': 'str'},
        'pages': {'key': 'pages', 'type': '[FacebookPage]'},
        'app_id': {'key': 'appId', 'type': 'str'},
        'app_secret': {'key': 'appSecret', 'type': 'str'},
        'callback_url': {'key': 'callbackUrl', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        app_id: str,
        is_enabled: bool,
        pages: Optional[List["FacebookPage"]] = None,
        app_secret: Optional[str] = None,
        **kwargs
    ):
        super(FacebookChannelProperties, self).__init__(**kwargs)
        self.verify_token = None
        self.pages = pages
        self.app_id = app_id
        self.app_secret = app_secret
        self.callback_url = None
        self.is_enabled = is_enabled


class FacebookPage(msrest.serialization.Model):
    """A Facebook page for Facebook channel registration.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Page id.
    :type id: str
    :param access_token: Facebook application access token. Value only returned through POST to the
     action Channel List API, otherwise empty.
    :type access_token: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'access_token': {'key': 'accessToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        access_token: Optional[str] = None,
        **kwargs
    ):
        super(FacebookPage, self).__init__(**kwargs)
        self.id = id
        self.access_token = access_token


class HostSettingsResponse(msrest.serialization.Model):
    """The response body returned for a request to Bot Service Management to check per subscription hostSettings.

    :param o_auth_url: For in-conversation bot user authentication.
    :type o_auth_url: str
    :param to_bot_from_channel_open_id_metadata_url: For verifying incoming tokens from the
     channels.
    :type to_bot_from_channel_open_id_metadata_url: str
    :param to_bot_from_channel_token_issuer: For verifying incoming tokens from the channels.
    :type to_bot_from_channel_token_issuer: str
    :param to_bot_from_emulator_open_id_metadata_url: For verifying incoming tokens from bot
     emulator.
    :type to_bot_from_emulator_open_id_metadata_url: str
    :param to_channel_from_bot_login_url: For getting access token to channels from bot host.
    :type to_channel_from_bot_login_url: str
    :param to_channel_from_bot_o_auth_scope: For getting access token to channels from bot host.
    :type to_channel_from_bot_o_auth_scope: str
    :param validate_authority: Per cloud OAuth setting on whether authority is validated.
    :type validate_authority: bool
    :param bot_open_id_metadata: Same as ToBotFromChannelOpenIdMetadataUrl, used by SDK < v4.12.
    :type bot_open_id_metadata: str
    """

    _attribute_map = {
        'o_auth_url': {'key': 'OAuthUrl', 'type': 'str'},
        'to_bot_from_channel_open_id_metadata_url': {'key': 'ToBotFromChannelOpenIdMetadataUrl', 'type': 'str'},
        'to_bot_from_channel_token_issuer': {'key': 'ToBotFromChannelTokenIssuer', 'type': 'str'},
        'to_bot_from_emulator_open_id_metadata_url': {'key': 'ToBotFromEmulatorOpenIdMetadataUrl', 'type': 'str'},
        'to_channel_from_bot_login_url': {'key': 'ToChannelFromBotLoginUrl', 'type': 'str'},
        'to_channel_from_bot_o_auth_scope': {'key': 'ToChannelFromBotOAuthScope', 'type': 'str'},
        'validate_authority': {'key': 'ValidateAuthority', 'type': 'bool'},
        'bot_open_id_metadata': {'key': 'BotOpenIdMetadata', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        o_auth_url: Optional[str] = None,
        to_bot_from_channel_open_id_metadata_url: Optional[str] = None,
        to_bot_from_channel_token_issuer: Optional[str] = None,
        to_bot_from_emulator_open_id_metadata_url: Optional[str] = None,
        to_channel_from_bot_login_url: Optional[str] = None,
        to_channel_from_bot_o_auth_scope: Optional[str] = None,
        validate_authority: Optional[bool] = None,
        bot_open_id_metadata: Optional[str] = None,
        **kwargs
    ):
        super(HostSettingsResponse, self).__init__(**kwargs)
        self.o_auth_url = o_auth_url
        self.to_bot_from_channel_open_id_metadata_url = to_bot_from_channel_open_id_metadata_url
        self.to_bot_from_channel_token_issuer = to_bot_from_channel_token_issuer
        self.to_bot_from_emulator_open_id_metadata_url = to_bot_from_emulator_open_id_metadata_url
        self.to_channel_from_bot_login_url = to_channel_from_bot_login_url
        self.to_channel_from_bot_o_auth_scope = to_channel_from_bot_o_auth_scope
        self.validate_authority = validate_authority
        self.bot_open_id_metadata = bot_open_id_metadata


class KikChannel(Channel):
    """Kik channel definition.

    All required parameters must be populated in order to send to Azure.

    :param channel_name: Required. The channel name.Constant filled by server.
    :type channel_name: str
    :param properties: The set of properties specific to Kik channel resource.
    :type properties: ~azure.mgmt.botservice.models.KikChannelProperties
    """

    _validation = {
        'channel_name': {'required': True},
    }

    _attribute_map = {
        'channel_name': {'key': 'channelName', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'KikChannelProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["KikChannelProperties"] = None,
        **kwargs
    ):
        super(KikChannel, self).__init__(**kwargs)
        self.channel_name = 'KikChannel'  # type: str
        self.properties = properties


class KikChannelProperties(msrest.serialization.Model):
    """The parameters to provide for the Kik channel.

    All required parameters must be populated in order to send to Azure.

    :param user_name: Required. The Kik user name.
    :type user_name: str
    :param api_key: Kik API key. Value only returned through POST to the action Channel List API,
     otherwise empty.
    :type api_key: str
    :param is_validated: Whether this channel is validated for the bot.
    :type is_validated: bool
    :param is_enabled: Required. Whether this channel is enabled for the bot.
    :type is_enabled: bool
    """

    _validation = {
        'user_name': {'required': True},
        'is_enabled': {'required': True},
    }

    _attribute_map = {
        'user_name': {'key': 'userName', 'type': 'str'},
        'api_key': {'key': 'apiKey', 'type': 'str'},
        'is_validated': {'key': 'isValidated', 'type': 'bool'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        user_name: str,
        is_enabled: bool,
        api_key: Optional[str] = None,
        is_validated: Optional[bool] = None,
        **kwargs
    ):
        super(KikChannelProperties, self).__init__(**kwargs)
        self.user_name = user_name
        self.api_key = api_key
        self.is_validated = is_validated
        self.is_enabled = is_enabled


class LineChannel(Channel):
    """Line channel definition.

    All required parameters must be populated in order to send to Azure.

    :param channel_name: Required. The channel name.Constant filled by server.
    :type channel_name: str
    :param properties: The set of properties specific to line channel resource.
    :type properties: ~azure.mgmt.botservice.models.LineChannelProperties
    """

    _validation = {
        'channel_name': {'required': True},
    }

    _attribute_map = {
        'channel_name': {'key': 'channelName', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'LineChannelProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["LineChannelProperties"] = None,
        **kwargs
    ):
        super(LineChannel, self).__init__(**kwargs)
        self.channel_name = 'LineChannel'  # type: str
        self.properties = properties


class LineChannelProperties(msrest.serialization.Model):
    """The parameters to provide for the Line channel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param line_registrations: Required. The list of line channel registrations.
    :type line_registrations: list[~azure.mgmt.botservice.models.LineRegistration]
    :ivar callback_url: Callback Url to enter in line registration.
    :vartype callback_url: str
    :ivar is_validated: Whether this channel is validated for the bot.
    :vartype is_validated: bool
    """

    _validation = {
        'line_registrations': {'required': True},
        'callback_url': {'readonly': True},
        'is_validated': {'readonly': True},
    }

    _attribute_map = {
        'line_registrations': {'key': 'lineRegistrations', 'type': '[LineRegistration]'},
        'callback_url': {'key': 'callbackUrl', 'type': 'str'},
        'is_validated': {'key': 'isValidated', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        line_registrations: List["LineRegistration"],
        **kwargs
    ):
        super(LineChannelProperties, self).__init__(**kwargs)
        self.line_registrations = line_registrations
        self.callback_url = None
        self.is_validated = None


class LineRegistration(msrest.serialization.Model):
    """The properties corresponding to a line channel registration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar generated_id: Id generated for the line channel registration.
    :vartype generated_id: str
    :param channel_secret: Secret for the line channel registration.
    :type channel_secret: str
    :param channel_access_token: Access token for the line channel registration.
    :type channel_access_token: str
    """

    _validation = {
        'generated_id': {'readonly': True},
    }

    _attribute_map = {
        'generated_id': {'key': 'generatedId', 'type': 'str'},
        'channel_secret': {'key': 'channelSecret', 'type': 'str'},
        'channel_access_token': {'key': 'channelAccessToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        channel_secret: Optional[str] = None,
        channel_access_token: Optional[str] = None,
        **kwargs
    ):
        super(LineRegistration, self).__init__(**kwargs)
        self.generated_id = None
        self.channel_secret = channel_secret
        self.channel_access_token = channel_access_token


class MsTeamsChannel(Channel):
    """Microsoft Teams channel definition.

    All required parameters must be populated in order to send to Azure.

    :param channel_name: Required. The channel name.Constant filled by server.
    :type channel_name: str
    :param properties: The set of properties specific to Microsoft Teams channel resource.
    :type properties: ~azure.mgmt.botservice.models.MsTeamsChannelProperties
    """

    _validation = {
        'channel_name': {'required': True},
    }

    _attribute_map = {
        'channel_name': {'key': 'channelName', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'MsTeamsChannelProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["MsTeamsChannelProperties"] = None,
        **kwargs
    ):
        super(MsTeamsChannel, self).__init__(**kwargs)
        self.channel_name = 'MsTeamsChannel'  # type: str
        self.properties = properties


class MsTeamsChannelProperties(msrest.serialization.Model):
    """The parameters to provide for the Microsoft Teams channel.

    All required parameters must be populated in order to send to Azure.

    :param enable_calling: Enable calling for Microsoft Teams channel.
    :type enable_calling: bool
    :param calling_web_hook: Webhook for Microsoft Teams channel calls.
    :type calling_web_hook: str
    :param is_enabled: Required. Whether this channel is enabled for the bot.
    :type is_enabled: bool
    """

    _validation = {
        'is_enabled': {'required': True},
    }

    _attribute_map = {
        'enable_calling': {'key': 'enableCalling', 'type': 'bool'},
        'calling_web_hook': {'key': 'callingWebHook', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        enable_calling: Optional[bool] = None,
        calling_web_hook: Optional[str] = None,
        **kwargs
    ):
        super(MsTeamsChannelProperties, self).__init__(**kwargs)
        self.enable_calling = enable_calling
        self.calling_web_hook = calling_web_hook
        self.is_enabled = is_enabled


class OperationDisplayInfo(msrest.serialization.Model):
    """The operation supported by Bot Service Management.

    :param description: The description of the operation.
    :type description: str
    :param operation: The action that users can perform, based on their permission level.
    :type operation: str
    :param provider: Service provider: Microsoft Bot Service.
    :type provider: str
    :param resource: Resource on which the operation is performed.
    :type resource: str
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        operation: Optional[str] = None,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        **kwargs
    ):
        super(OperationDisplayInfo, self).__init__(**kwargs)
        self.description = description
        self.operation = operation
        self.provider = provider
        self.resource = resource


class OperationEntity(msrest.serialization.Model):
    """The operations supported by Bot Service Management.

    :param name: Operation name: {provider}/{resource}/{operation}.
    :type name: str
    :param display: The operation supported by Bot Service Management.
    :type display: ~azure.mgmt.botservice.models.OperationDisplayInfo
    :param origin: The origin of the operation.
    :type origin: str
    :param properties: Additional properties.
    :type properties: any
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplayInfo'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["OperationDisplayInfo"] = None,
        origin: Optional[str] = None,
        properties: Optional[Any] = None,
        **kwargs
    ):
        super(OperationEntity, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.properties = properties


class OperationEntityListResult(msrest.serialization.Model):
    """The list of bot service operation response.

    :param next_link: The link used to get the next page of operations.
    :type next_link: str
    :param value: The list of operations.
    :type value: list[~azure.mgmt.botservice.models.OperationEntity]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[OperationEntity]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["OperationEntity"]] = None,
        **kwargs
    ):
        super(OperationEntityListResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ServiceProvider(msrest.serialization.Model):
    """Service Provider Definition.

    :param properties: The Properties of a Service Provider Object.
    :type properties: ~azure.mgmt.botservice.models.ServiceProviderProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'ServiceProviderProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["ServiceProviderProperties"] = None,
        **kwargs
    ):
        super(ServiceProvider, self).__init__(**kwargs)
        self.properties = properties


class ServiceProviderParameter(msrest.serialization.Model):
    """Extra Parameters specific to each Service Provider.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the Service Provider.
    :vartype name: str
    :ivar type: Type of the Service Provider.
    :vartype type: str
    :ivar display_name: Display Name of the Service Provider.
    :vartype display_name: str
    :ivar description: Description of the Service Provider.
    :vartype description: str
    :ivar help_url: Help Url for the  Service Provider.
    :vartype help_url: str
    :ivar default: Default Name for the Service Provider.
    :vartype default: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'help_url': {'readonly': True},
        'default': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'help_url': {'key': 'helpUrl', 'type': 'str'},
        'default': {'key': 'default', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceProviderParameter, self).__init__(**kwargs)
        self.name = None
        self.type = None
        self.display_name = None
        self.description = None
        self.help_url = None
        self.default = None


class ServiceProviderProperties(msrest.serialization.Model):
    """The Object used to describe a Service Provider supported by Bot Service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Id for Service Provider.
    :vartype id: str
    :ivar display_name: Display Name of the Service Provider.
    :vartype display_name: str
    :ivar service_provider_name: Display Name of the Service Provider.
    :vartype service_provider_name: str
    :ivar dev_portal_url: Display Name of the Service Provider.
    :vartype dev_portal_url: str
    :ivar icon_url: Display Name of the Service Provider.
    :vartype icon_url: str
    :param parameters: The list of parameters for the Service Provider.
    :type parameters: list[~azure.mgmt.botservice.models.ServiceProviderParameter]
    """

    _validation = {
        'id': {'readonly': True},
        'display_name': {'readonly': True},
        'service_provider_name': {'readonly': True},
        'dev_portal_url': {'readonly': True},
        'icon_url': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'service_provider_name': {'key': 'serviceProviderName', 'type': 'str'},
        'dev_portal_url': {'key': 'devPortalUrl', 'type': 'str'},
        'icon_url': {'key': 'iconUrl', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '[ServiceProviderParameter]'},
    }

    def __init__(
        self,
        *,
        parameters: Optional[List["ServiceProviderParameter"]] = None,
        **kwargs
    ):
        super(ServiceProviderProperties, self).__init__(**kwargs)
        self.id = None
        self.display_name = None
        self.service_provider_name = None
        self.dev_portal_url = None
        self.icon_url = None
        self.parameters = parameters


class ServiceProviderResponseList(msrest.serialization.Model):
    """The list of bot service providers response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param next_link: The link used to get the next page of bot service providers.
    :type next_link: str
    :ivar value: Gets the list of bot service providers and their properties.
    :vartype value: list[~azure.mgmt.botservice.models.ServiceProvider]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[ServiceProvider]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ServiceProviderResponseList, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = None


class SiteInfo(msrest.serialization.Model):
    """Site information for WebChat or DirectLine Channels to identify which site to regenerate keys for.

    All required parameters must be populated in order to send to Azure.

    :param site_name: Required. The site name.
    :type site_name: str
    :param key: Required. Determines which key is to be regenerated. Possible values include:
     "key1", "key2".
    :type key: str or ~azure.mgmt.botservice.models.Key
    """

    _validation = {
        'site_name': {'required': True},
        'key': {'required': True},
    }

    _attribute_map = {
        'site_name': {'key': 'siteName', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        site_name: str,
        key: Union[str, "Key"],
        **kwargs
    ):
        super(SiteInfo, self).__init__(**kwargs)
        self.site_name = site_name
        self.key = key


class Sku(msrest.serialization.Model):
    """The SKU of the cognitive services account.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The sku name. Possible values include: "F0", "S1".
    :type name: str or ~azure.mgmt.botservice.models.SkuName
    :ivar tier: Gets the sku tier. This is based on the SKU name. Possible values include: "Free",
     "Standard".
    :vartype tier: str or ~azure.mgmt.botservice.models.SkuTier
    """

    _validation = {
        'name': {'required': True},
        'tier': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Union[str, "SkuName"],
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = name
        self.tier = None


class SkypeChannel(Channel):
    """Skype channel definition.

    All required parameters must be populated in order to send to Azure.

    :param channel_name: Required. The channel name.Constant filled by server.
    :type channel_name: str
    :param properties: The set of properties specific to Skype channel resource.
    :type properties: ~azure.mgmt.botservice.models.SkypeChannelProperties
    """

    _validation = {
        'channel_name': {'required': True},
    }

    _attribute_map = {
        'channel_name': {'key': 'channelName', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'SkypeChannelProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["SkypeChannelProperties"] = None,
        **kwargs
    ):
        super(SkypeChannel, self).__init__(**kwargs)
        self.channel_name = 'SkypeChannel'  # type: str
        self.properties = properties


class SkypeChannelProperties(msrest.serialization.Model):
    """The parameters to provide for the Microsoft Teams channel.

    All required parameters must be populated in order to send to Azure.

    :param enable_messaging: Enable messaging for Skype channel.
    :type enable_messaging: bool
    :param enable_media_cards: Enable media cards for Skype channel.
    :type enable_media_cards: bool
    :param enable_video: Enable video for Skype channel.
    :type enable_video: bool
    :param enable_calling: Enable calling for Skype channel.
    :type enable_calling: bool
    :param enable_screen_sharing: Enable screen sharing for Skype channel.
    :type enable_screen_sharing: bool
    :param enable_groups: Enable groups for Skype channel.
    :type enable_groups: bool
    :param groups_mode: Group mode for Skype channel.
    :type groups_mode: str
    :param calling_web_hook: Calling web hook for Skype channel.
    :type calling_web_hook: str
    :param is_enabled: Required. Whether this channel is enabled for the bot.
    :type is_enabled: bool
    """

    _validation = {
        'is_enabled': {'required': True},
    }

    _attribute_map = {
        'enable_messaging': {'key': 'enableMessaging', 'type': 'bool'},
        'enable_media_cards': {'key': 'enableMediaCards', 'type': 'bool'},
        'enable_video': {'key': 'enableVideo', 'type': 'bool'},
        'enable_calling': {'key': 'enableCalling', 'type': 'bool'},
        'enable_screen_sharing': {'key': 'enableScreenSharing', 'type': 'bool'},
        'enable_groups': {'key': 'enableGroups', 'type': 'bool'},
        'groups_mode': {'key': 'groupsMode', 'type': 'str'},
        'calling_web_hook': {'key': 'callingWebHook', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        enable_messaging: Optional[bool] = None,
        enable_media_cards: Optional[bool] = None,
        enable_video: Optional[bool] = None,
        enable_calling: Optional[bool] = None,
        enable_screen_sharing: Optional[bool] = None,
        enable_groups: Optional[bool] = None,
        groups_mode: Optional[str] = None,
        calling_web_hook: Optional[str] = None,
        **kwargs
    ):
        super(SkypeChannelProperties, self).__init__(**kwargs)
        self.enable_messaging = enable_messaging
        self.enable_media_cards = enable_media_cards
        self.enable_video = enable_video
        self.enable_calling = enable_calling
        self.enable_screen_sharing = enable_screen_sharing
        self.enable_groups = enable_groups
        self.groups_mode = groups_mode
        self.calling_web_hook = calling_web_hook
        self.is_enabled = is_enabled


class SlackChannel(Channel):
    """Slack channel definition.

    All required parameters must be populated in order to send to Azure.

    :param channel_name: Required. The channel name.Constant filled by server.
    :type channel_name: str
    :param properties: The set of properties specific to Slack channel resource.
    :type properties: ~azure.mgmt.botservice.models.SlackChannelProperties
    """

    _validation = {
        'channel_name': {'required': True},
    }

    _attribute_map = {
        'channel_name': {'key': 'channelName', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'SlackChannelProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["SlackChannelProperties"] = None,
        **kwargs
    ):
        super(SlackChannel, self).__init__(**kwargs)
        self.channel_name = 'SlackChannel'  # type: str
        self.properties = properties


class SlackChannelProperties(msrest.serialization.Model):
    """The parameters to provide for the Slack channel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param client_id: The Slack client id.
    :type client_id: str
    :param client_secret: The Slack client secret. Value only returned through POST to the action
     Channel List API, otherwise empty.
    :type client_secret: str
    :param verification_token: The Slack verification token. Value only returned through POST to
     the action Channel List API, otherwise empty.
    :type verification_token: str
    :param landing_page_url: The Slack landing page Url.
    :type landing_page_url: str
    :ivar redirect_action: The Slack redirect action.
    :vartype redirect_action: str
    :ivar last_submission_id: The Sms auth token.
    :vartype last_submission_id: str
    :ivar register_before_o_auth_flow: Whether to register the settings before OAuth validation is
     performed. Recommended to True.
    :vartype register_before_o_auth_flow: bool
    :ivar is_validated: Whether this channel is validated for the bot.
    :vartype is_validated: bool
    :param signing_secret: The Slack signing secret.
    :type signing_secret: str
    :param is_enabled: Required. Whether this channel is enabled for the bot.
    :type is_enabled: bool
    """

    _validation = {
        'redirect_action': {'readonly': True},
        'last_submission_id': {'readonly': True},
        'register_before_o_auth_flow': {'readonly': True},
        'is_validated': {'readonly': True},
        'is_enabled': {'required': True},
    }

    _attribute_map = {
        'client_id': {'key': 'clientId', 'type': 'str'},
        'client_secret': {'key': 'clientSecret', 'type': 'str'},
        'verification_token': {'key': 'verificationToken', 'type': 'str'},
        'landing_page_url': {'key': 'landingPageUrl', 'type': 'str'},
        'redirect_action': {'key': 'redirectAction', 'type': 'str'},
        'last_submission_id': {'key': 'lastSubmissionId', 'type': 'str'},
        'register_before_o_auth_flow': {'key': 'registerBeforeOAuthFlow', 'type': 'bool'},
        'is_validated': {'key': 'isValidated', 'type': 'bool'},
        'signing_secret': {'key': 'signingSecret', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        client_id: Optional[str] = None,
        client_secret: Optional[str] = None,
        verification_token: Optional[str] = None,
        landing_page_url: Optional[str] = None,
        signing_secret: Optional[str] = None,
        **kwargs
    ):
        super(SlackChannelProperties, self).__init__(**kwargs)
        self.client_id = client_id
        self.client_secret = client_secret
        self.verification_token = verification_token
        self.landing_page_url = landing_page_url
        self.redirect_action = None
        self.last_submission_id = None
        self.register_before_o_auth_flow = None
        self.is_validated = None
        self.signing_secret = signing_secret
        self.is_enabled = is_enabled


class SmsChannel(Channel):
    """Sms channel definition.

    All required parameters must be populated in order to send to Azure.

    :param channel_name: Required. The channel name.Constant filled by server.
    :type channel_name: str
    :param properties: The set of properties specific to Sms channel resource.
    :type properties: ~azure.mgmt.botservice.models.SmsChannelProperties
    """

    _validation = {
        'channel_name': {'required': True},
    }

    _attribute_map = {
        'channel_name': {'key': 'channelName', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'SmsChannelProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["SmsChannelProperties"] = None,
        **kwargs
    ):
        super(SmsChannel, self).__init__(**kwargs)
        self.channel_name = 'SmsChannel'  # type: str
        self.properties = properties


class SmsChannelProperties(msrest.serialization.Model):
    """The parameters to provide for the Sms channel.

    All required parameters must be populated in order to send to Azure.

    :param phone: Required. The Sms phone.
    :type phone: str
    :param account_sid: Required. The Sms account SID. Value only returned through POST to the
     action Channel List API, otherwise empty.
    :type account_sid: str
    :param auth_token: The Sms auth token. Value only returned through POST to the action Channel
     List API, otherwise empty.
    :type auth_token: str
    :param is_validated: Whether this channel is validated for the bot.
    :type is_validated: bool
    :param is_enabled: Required. Whether this channel is enabled for the bot.
    :type is_enabled: bool
    """

    _validation = {
        'phone': {'required': True},
        'account_sid': {'required': True},
        'is_enabled': {'required': True},
    }

    _attribute_map = {
        'phone': {'key': 'phone', 'type': 'str'},
        'account_sid': {'key': 'accountSID', 'type': 'str'},
        'auth_token': {'key': 'authToken', 'type': 'str'},
        'is_validated': {'key': 'isValidated', 'type': 'bool'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        phone: str,
        account_sid: str,
        is_enabled: bool,
        auth_token: Optional[str] = None,
        is_validated: Optional[bool] = None,
        **kwargs
    ):
        super(SmsChannelProperties, self).__init__(**kwargs)
        self.phone = phone
        self.account_sid = account_sid
        self.auth_token = auth_token
        self.is_validated = is_validated
        self.is_enabled = is_enabled


class TelegramChannel(Channel):
    """Telegram channel definition.

    All required parameters must be populated in order to send to Azure.

    :param channel_name: Required. The channel name.Constant filled by server.
    :type channel_name: str
    :param properties: The set of properties specific to Telegram channel resource.
    :type properties: ~azure.mgmt.botservice.models.TelegramChannelProperties
    """

    _validation = {
        'channel_name': {'required': True},
    }

    _attribute_map = {
        'channel_name': {'key': 'channelName', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'TelegramChannelProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["TelegramChannelProperties"] = None,
        **kwargs
    ):
        super(TelegramChannel, self).__init__(**kwargs)
        self.channel_name = 'TelegramChannel'  # type: str
        self.properties = properties


class TelegramChannelProperties(msrest.serialization.Model):
    """The parameters to provide for the Telegram channel.

    All required parameters must be populated in order to send to Azure.

    :param access_token: The Telegram access token. Value only returned through POST to the action
     Channel List API, otherwise empty.
    :type access_token: str
    :param is_validated: Whether this channel is validated for the bot.
    :type is_validated: bool
    :param is_enabled: Required. Whether this channel is enabled for the bot.
    :type is_enabled: bool
    """

    _validation = {
        'is_enabled': {'required': True},
    }

    _attribute_map = {
        'access_token': {'key': 'accessToken', 'type': 'str'},
        'is_validated': {'key': 'isValidated', 'type': 'bool'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        access_token: Optional[str] = None,
        is_validated: Optional[bool] = None,
        **kwargs
    ):
        super(TelegramChannelProperties, self).__init__(**kwargs)
        self.access_token = access_token
        self.is_validated = is_validated
        self.is_enabled = is_enabled


class WebChatChannel(Channel):
    """Web Chat channel definition.

    All required parameters must be populated in order to send to Azure.

    :param channel_name: Required. The channel name.Constant filled by server.
    :type channel_name: str
    :param properties: The set of properties specific to Web Chat channel resource.
    :type properties: ~azure.mgmt.botservice.models.WebChatChannelProperties
    """

    _validation = {
        'channel_name': {'required': True},
    }

    _attribute_map = {
        'channel_name': {'key': 'channelName', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'WebChatChannelProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["WebChatChannelProperties"] = None,
        **kwargs
    ):
        super(WebChatChannel, self).__init__(**kwargs)
        self.channel_name = 'WebChatChannel'  # type: str
        self.properties = properties


class WebChatChannelProperties(msrest.serialization.Model):
    """The parameters to provide for the Web Chat channel.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar web_chat_embed_code: Web chat control embed code.
    :vartype web_chat_embed_code: str
    :param sites: The list of Web Chat sites.
    :type sites: list[~azure.mgmt.botservice.models.WebChatSite]
    """

    _validation = {
        'web_chat_embed_code': {'readonly': True},
    }

    _attribute_map = {
        'web_chat_embed_code': {'key': 'webChatEmbedCode', 'type': 'str'},
        'sites': {'key': 'sites', 'type': '[WebChatSite]'},
    }

    def __init__(
        self,
        *,
        sites: Optional[List["WebChatSite"]] = None,
        **kwargs
    ):
        super(WebChatChannelProperties, self).__init__(**kwargs)
        self.web_chat_embed_code = None
        self.sites = sites


class WebChatSite(msrest.serialization.Model):
    """A site for the Webchat channel.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar site_id: Site Id.
    :vartype site_id: str
    :param site_name: Required. Site name.
    :type site_name: str
    :ivar key: Primary key. Value only returned through POST to the action Channel List API,
     otherwise empty.
    :vartype key: str
    :ivar key2: Secondary key. Value only returned through POST to the action Channel List API,
     otherwise empty.
    :vartype key2: str
    :param is_enabled: Required. Whether this site is enabled for DirectLine channel.
    :type is_enabled: bool
    :param enable_preview: Required. Whether this site is enabled for preview versions of Webchat.
    :type enable_preview: bool
    """

    _validation = {
        'site_id': {'readonly': True},
        'site_name': {'required': True},
        'key': {'readonly': True},
        'key2': {'readonly': True},
        'is_enabled': {'required': True},
        'enable_preview': {'required': True},
    }

    _attribute_map = {
        'site_id': {'key': 'siteId', 'type': 'str'},
        'site_name': {'key': 'siteName', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'key2': {'key': 'key2', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'enable_preview': {'key': 'enablePreview', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        site_name: str,
        is_enabled: bool,
        enable_preview: bool,
        **kwargs
    ):
        super(WebChatSite, self).__init__(**kwargs)
        self.site_id = None
        self.site_name = site_name
        self.key = None
        self.key2 = None
        self.is_enabled = is_enabled
        self.enable_preview = enable_preview
