# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.resourcehealth import ResourceHealthMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestResourceHealthMgmtImpactedResourcesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ResourceHealthMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_subscription_id_and_event_id(self, resource_group):
        response = self.client.impacted_resources.list_by_subscription_id_and_event_id(
            event_tracking_id="str",
            api_version="2023-10-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get(self, resource_group):
        response = self.client.impacted_resources.get(
            event_tracking_id="str",
            impacted_resource_name="str",
            api_version="2023-10-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_tenant_id_and_event_id(self, resource_group):
        response = self.client.impacted_resources.list_by_tenant_id_and_event_id(
            event_tracking_id="str",
            api_version="2023-10-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get_by_tenant_id(self, resource_group):
        response = self.client.impacted_resources.get_by_tenant_id(
            event_tracking_id="str",
            impacted_resource_name="str",
            api_version="2023-10-01-preview",
        )

        # please add some check logic here by yourself
        # ...
