import graphene
from graphene.relay import Node

from graphene_mongo import MongoengineConnectionField, MongoengineObjectType
from .models import Department as DepartmentModel
from .models import Employee as EmployeeModel
from .models import Role as RoleModel
from .models import Task as TaskModel


class Department(MongoengineObjectType):
    class Meta:
        model = DepartmentModel
        interfaces = (Node,)


class Role(MongoengineObjectType):
    class Meta:
        model = RoleModel
        interfaces = (Node,)
        filter_fields = {
            "name": [
                "exact",
                "icontains",
                "istartswith",
            ]
        }


class Task(MongoengineObjectType):
    class Meta:
        model = TaskModel
        interfaces = (Node,)


class Employee(MongoengineObjectType):
    class Meta:
        model = EmployeeModel
        interfaces = (Node,)
        filter_fields = {
            "name": [
                "exact",
                "icontains",
                "istartswith",
            ]
        }


class Query(graphene.ObjectType):
    node = Node.Field()
    all_employees = MongoengineConnectionField(Employee)
    all_roles = MongoengineConnectionField(Role)
    role = graphene.Field(Role)


schema = graphene.Schema(query=Query, types=[Department, Employee, Role])
