/***************************************************************************
                          qcakerun.cpp  -  description
                             -------------------
    begin                : Mon Sep  18 16:54:22 CET 2006
    copyright            : (C) 2004 by Harald Krippel
    email                : harald@the-develop.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Qt includes
//#include <qsettings.h>
#include <QtGui>
// application specific includes
#include "globdefines.h"
#include "qcakerun.h"
#include "main.h"
#include "glcontrol.hpp"
#include "playerview.h"
#include "opmltree.hpp"

QcakeRunApp::QcakeRunApp(QObject *parent):QObject(parent)
{
//  view = NULL;
  opmlTree = new OpmlTree();
  initView();
}

QcakeRunApp::~QcakeRunApp()
{

}


void QcakeRunApp::initView()
{ 
//  view = new PlayerView();
}

void QcakeRunApp::openDocumentFile(QString fileName)
{
    // Load File
    if (fileName.isEmpty())
        return;

    QFile file(fileName);
    if (!file.open(QFile::ReadOnly | QFile::Text)) {

//        QMessageBox::warning(this, tr("QCake File"),
//                             tr("Cannot read file %1:\n%2.")
//                             .arg(fileName)
//                             .arg(file.errorString()));
        QString msg = "Cannot read file " + fileName;
        qWarning(msg.toAscii());

        return;
    }
    g_nextid=0;
    g_prjpath =  QFileInfo(file).filePath();
    g_prjpath = g_prjpath.left(g_prjpath.lastIndexOf(QFileInfo(file).fileName()));
    qWarning( g_prjpath.toAscii() );

    if (opmlTree->read(&file)){
        g_tmpItem=opmlTree->getStart();
        if (g_tmpItem != NULL && g_gl != NULL){    // only it exist !!
          g_gl->switchScene(g_tmpItem);
        }
    }
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

void QcakeRunApp::slotToolsPlay()
{
  g_gl->compile();
  g_playmode = 1;
}

void QcakeRunApp::slotToolsPause()
{

  g_playmode = 0;
  toolsPlay->setEnabled(true);
  toolsStop->setEnabled(false);
  if(g_gl != NULL)
  {
    g_gl->StopSound();
  }
}

void QcakeRunApp::slotToolsStop()
{
      g_playmode = 0;
      if (g_tmpItem != NULL && g_gl != NULL)    // only it exist !!
      {
         g_gl->switchScene(g_tmpItem);
      }
}
