% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H5G.R
\name{H5Gget_info}
\alias{H5Gget_info}
\alias{H5Gget_info_by_name}
\alias{H5Gget_info_by_idx}
\title{Retrieve information about a group}
\usage{
H5Gget_info(h5loc)

H5Gget_info_by_name(h5loc, group_name)

H5Gget_info_by_idx(
  h5loc,
  n,
  group_name = ".",
  index_type = h5default("H5_INDEX"),
  order = h5default("H5_ITER")
)
}
\arguments{
\item{h5loc}{An object of class \linkS4class{H5IdComponent} representing a H5
group.}

\item{group_name}{An additional group name specifying the group for which
information is sought. It is interpreted relative to \code{h5loc}.}

\item{n}{Position in the index of the group for which information is
retrieved.}

\item{index_type}{See \code{h5const("H5_INDEX")} for possible arguments.}

\item{order}{See \code{h5const("H5_ITER")} for possible arguments.}
}
\value{
A list with group information
}
\description{
Retrieve information about a group
}
\examples{
h5file <- system.file("testfiles", "multiple_dtypes.h5", package="rhdf5")
fid <- H5Fopen(h5file)
gid <- H5Gopen(fid, "/foo")
gid
H5Gget_info(gid)
H5Gclose(gid)

## the "get_info_by" functions take the H5 object that contains the
## group(s) of interest.  We can retrieve information by index or by name
H5Gget_info_by_idx(fid, 3)
H5Gget_info_by_name(fid,"/foo")

H5Fclose(fid)

}
