% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LedergorMyelomaData.R
\name{LedergorMyelomaData}
\alias{LedergorMyelomaData}
\title{Obtain the Ledergor Myeloma data}
\usage{
LedergorMyelomaData(ensembl = FALSE, location = TRUE)
}
\arguments{
\item{ensembl}{Logical scalar indicating whether the output row names should contain Ensembl identifiers.}

\item{location}{Logical scalar indicating whether genomic coordinates should be returned.}
}
\value{
A \linkS4class{SingleCellExperiment} object with a single matrix of read counts.
}
\description{
Obtain the human multiple myeloma single-cell RNA-seq data from Ledergor et al. (2018).
}
\details{
Column metadata was created from the sample metadata file in GSE117156. It contains an 'Experiment_ID' column,
from which the tissue and subject of origin were extracted, as well as the condition and treatment status of the subject.

If \code{ensembl=TRUE}, the gene symbols are converted to Ensembl IDs in the row names of the output object.
Rows with missing Ensembl IDs are discarded, and only the first occurrence of duplicated IDs is retained.

If \code{location=TRUE}, the coordinates of the Ensembl gene models are stored in the \code{\link{rowRanges}} of the output.
Note that this is only performed if \code{ensembl=TRUE}.

All data are downloaded from ExperimentHub and cached for local re-use.
Specific resources can be retrieved by searching for \code{scRNAseq/ledergor-myeloma}.
}
\examples{
sce <- LedergorMyelomaData()

}
\references{
Ledergor G et al. (2018)
Single cell dissection of plasma cell heterogeneity in symptomatic and
asymptomatic myeloma. \emph{Nat Med.} 24(12), 1867–1876.
}
\author{
Milan Malfait
}
