% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UsoskinBrainData.R
\name{UsoskinBrainData}
\alias{UsoskinBrainData}
\title{Obtain the Usoskin brain data}
\usage{
UsoskinBrainData(ensembl = FALSE, location = TRUE, legacy = FALSE)
}
\arguments{
\item{ensembl}{Logical scalar indicating whether the output row names should contain Ensembl identifiers.}

\item{location}{Logical scalar indicating whether genomic coordinates should be returned.}

\item{legacy}{Logical scalar indicating whether to pull data from ExperimentHub.
By default, we use data from the gypsum backend.}
}
\value{
A \linkS4class{SingleCellExperiment} object with a single matrix of RPMs.
}
\description{
Obtain the mouse brain single-cell RNA-seq dataset from Usoskin et al. (2015).
}
\details{
Column metadata is provided in the same form as supplied in External Table 2 of \url{http://linnarssonlab.org/drg/}.
This contains information such as the library of origin and the cell type.

The count matrix contains information for repeats, marked with \code{r_} prefixes in the row names;
as well as mitochondrial transcripts, marked with \code{mt-} prefixes.

If \code{ensembl=TRUE}, the gene symbols are converted to Ensembl IDs in the row names of the output object.
Rows with missing Ensembl IDs are discarded, and only the first occurrence of duplicated IDs is retained.

If \code{location=TRUE}, the coordinates of the Ensembl gene models are stored in the \code{\link{rowRanges}} of the output.
Note that this is only performed if \code{ensembl=TRUE}.

All data are downloaded from ExperimentHub and cached for local re-use.
Specific resources can be retrieved by searching for \code{scRNAseq/usoskin-brain}.
}
\examples{
sce <- UsoskinBrainData()

}
\references{
Usoskin A et al. (2015).
Unbiased classification of sensory neuron types by large-scale single-cell RNA sequencing. 
\emph{Nat. Neurosci.} 18(1), 145-53.
}
\author{
Aaron Lun
}
