% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebook.R
\name{epub_book}
\alias{epub_book}
\title{The EPUB e-book format}
\usage{
epub_book(
  fig_width = 5,
  fig_height = 4,
  dev = "png",
  fig_caption = TRUE,
  number_sections = TRUE,
  toc = FALSE,
  toc_depth = 3,
  stylesheet = NULL,
  cover_image = NULL,
  metadata = NULL,
  chapter_level = 1,
  epub_version = c("epub3", "epub", "epub2"),
  md_extensions = NULL,
  global_numbering = !number_sections,
  pandoc_args = NULL,
  template = "default"
)
}
\arguments{
\item{fig_width, fig_height, dev, fig_caption}{Figure options (width, height,
the graphical device, and whether to render figure captions).}

\item{number_sections}{Whether to number sections.}

\item{toc, toc_depth}{Whether to generate a table of contents, and its depth.}

\item{stylesheet}{A character vector of paths to CSS stylesheets to be
applied to the eBook.}

\item{cover_image}{The path to a cover image.}

\item{metadata}{The path to the EPUB metadata file.}

\item{chapter_level}{The level by which the e-book is split into separate
\dQuote{chapter} files.}

\item{epub_version}{Whether to use version 3 or 2 of EPUB. This correspond to
\href{https://pandoc.org/MANUAL.html#option--to}{Pandoc's supported output format}. \code{"epub"} is an alias
for \code{"epub3"} since Pandoc 2.0 and \code{"epub2"} for earlier version.}

\item{md_extensions}{A character string of Pandoc Markdown extensions.}

\item{global_numbering}{If \code{TRUE}, number figures and tables globally
throughout a document (e.g., Figure 1, Figure 2, ...). If \code{FALSE},
number them sequentially within sections (e.g., Figure 1.1, Figure 1.2,
..., Figure 5.1, Figure 5.2, ...). Note that \code{global_numbering =
FALSE} will not work with \code{number_sections = FALSE} because sections
are not numbered.}

\item{pandoc_args}{A vector of additional Pandoc arguments.}

\item{template}{Pandoc template to use for rendering. Pass \code{"default"}
to use Pandoc's built-in template; pass a path to use a custom template.
The default pandoc template should be sufficient for most use cases. In
case you want to develop a custom template, we highly recommend to start
from the default EPUB templates at
\url{https://github.com/jgm/pandoc-templates/}.}
}
\description{
Convert a book to the EPUB format, which is is an e-book format supported by
many readers, such as Amazon Kindle Fire and iBooks on Apple devices.
}
\note{
Figure/table numbers cannot be generated if sections are not numbered
(\code{number_sections = FALSE}).
}
