\name{loadBioTapestry}
\alias{loadBioTapestry}
\title{
Import a network from BioTapestry
}
\description{
Imports a Boolean network from a BioTapestry file (*.btp). BioTapestry is an interactive tool for building, visualizing, and simulating gene-regulatory networks, and can be accessed at \url{https://biotapestry.systemsbiology.net}. 
}
\usage{
loadBioTapestry(file,
                symbolic = FALSE)
}
\arguments{
  \item{file}{
The name of the file to import. This must be a BioTapestry XML file (*.btp).
}
  
  \item{symbolic}{
If set to \code{TRUE}, the function returns an object of class \code{SymbolicBooleanNetwork} with an expression tree representation. Otherwise, it returns an object of class \code{BooleanNetwork} with a truth table representation.
}
}
\details{
The function builds up a Boolean network by importing the nodes, the links between these nodes, and the simulation parameters of the top-level plot of a BioTapestry file. The BioTapestry network should have the following properties:
\itemize{

\item All links should be either enhancers or repressors. Unspecified ("neutral") links are ignored.
\item In the simulation parameters, each node should specify the correct logical function (AND, OR, XOR) for its inputs.
\item Constant genes can be generated by modeling a gene without any input link and setting the simulation parameter \code{initVal} to 0 or 1.
}
}
\value{
A network of class \code{BooleanNetwork} or \code{SymbolicBooleanNetwork}, as described in \code{\link{loadNetwork}}.
}
\references{
W. J. R. Longabaugh, E. H. Davidson, H. Bolour (2005), Computational representation of developmental genetic regulatory networks. Developmental Biology 283(1):1--16.
}

\seealso{
\code{\link{loadNetwork}}, \code{\link{loadSBML}}
}
\examples{
# import the example BioTapestry file
# included in the package vignette
exampleFile <- system.file("doc/example.btp",
                           package="BoolNet")
net <- loadBioTapestry(exampleFile)

# print the imported network
print(net)
}