% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geomsv.R
\docType{data}
\name{geom_vridgeline}
\alias{geom_vridgeline}
\alias{GeomVRidgeline}
\title{Plot a vertical ridgeline (ridgeline rotated 90 degrees)}
\usage{
geom_vridgeline(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}} or
\code{\link[=aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame.}, and
will be used as the layer data.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them.}

\item{...}{other arguments passed on to \code{\link[=layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{linewidth = 3}. They may also be parameters
to the paired geom/stat.}
}
\description{
Plots the sum of the \code{x} and \code{width} aesthetics versus \code{y}, filling the area between \code{x} and \code{x + width} with a color.
Just like \code{\link[=geom_ridgeline]{geom_ridgeline()}}, but with y and x replaced.
}
\section{Aesthetics}{


Required aesthetics are in bold.
\itemize{
\item \strong{\code{x}}
\item \strong{\code{y}}
\item \strong{\code{width}} Width of the ridgeline, measured from the respective \code{x} value. Assumed to be positive, though this is not required.
\item \code{group} Defines the grouping. Required when the dataset contains multiple distinct ridgelines. Will typically be the same
variable as is mapped to \code{x}.
\item \code{scale} A scaling factor to scale the widths of the ridgelines.
A value of 1 indicates that the widths are taken as is. This aesthetic can be used to convert
\code{width} units into \code{x} units.
\item \code{min_width} A width cutoff on the drawn ridgelines. All values that fall below this cutoff will be removed.
The main purpose of this cutoff is to remove long tails right at the baseline level, but other uses are possible.
The cutoff is applied before any width
scaling is applied via the \code{scale} aesthetic. Default is 0, so negative values are removed.
\item \code{color} Color of the ridgeline
\item \code{fill} Fill color of the area under the ridgeline
\item \code{alpha} Transparency level of \code{fill}. Not applied to \code{color}. If you want transparent lines, you can set their
color as RGBA value, e.g. #FF0000A0 for partially transparent red.
\item \code{group} Grouping, to draw multiple ridgelines from one dataset
\item \code{linetype} Linetype of the ridgeline
\item \code{linewidth} Line thickness
}
}

\examples{
library(ggplot2)

d <- data.frame(y = rep(1:5, 3), x = c(rep(0, 5), rep(1, 5), rep(3, 5)),
                width = c(0, 1, 3, 4, 0, 1, 2, 3, 5, 4, 0, 5, 4, 4, 1))
ggplot(d, aes(x, y, width = width, group = x)) + geom_vridgeline(fill="lightblue")

ggplot(iris, aes(x=Species, y=Sepal.Width, width = after_stat(density), fill=Species)) +
  geom_vridgeline(stat="ydensity", trim=FALSE, alpha = 0.85, scale = 2)

}
\keyword{datasets}
