% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Classification.R
\name{KS_Stat}
\alias{KS_Stat}
\title{Kolmogorov-Smirnov Statistic}
\usage{
KS_Stat(y_pred, y_true)
}
\arguments{
\item{y_pred}{Predicted probabilities vector, as returned by a classifier}

\item{y_true}{Ground truth (correct) 0-1 labels vector}
}
\value{
Kolmogorov-Smirnov statistic
}
\description{
Compute the Kolmogorov-Smirnov statistic.
}
\examples{
data(cars)
logreg <- glm(formula = vs ~ hp + wt,
              family = binomial(link = "logit"), data = mtcars)
KS_Stat(y_pred = logreg$fitted.values, y_true = mtcars$vs)
}

