% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.subgroupAnalysis.R
\name{summary.subgroupAnalysis}
\alias{summary.subgroupAnalysis}
\title{summary.subgroupAnalysis}
\usage{
\method{summary}{subgroupAnalysis}(
  object,
  digits = 3,
  eps = 0.001,
  subgroup.p = FALSE,
  keep.digital = FALSE,
  ...
)
}
\arguments{
\item{object}{- a subgroupAnalysis object}

\item{digits}{- number of digits for risk ratios}

\item{eps}{- lowest value of p to be shown exactly, others will be "<eps"}

\item{subgroup.p}{- present p-values for analyses in subgroups}

\item{keep.digital}{- prevents formatting risk ratio and confidence limits. Useful
for cases when further manipulations of rows and columns prior to adding a
forest plot is relevant.}

\item{...}{- not currently used}
}
\value{
A data.frame with formatted values for subgroups
}
\description{
This function operates on a "subgroupAnalysis" object to produce a formatted
table.
}
\details{
This function produces a formatted or unformatted table of a subgroupAnalysis object.
A forest plot can be added with the plot function.
}
\examples{
#load libraries
library(Publish)
library(survival)
library(data.table)
data(traceR) #get dataframe traceR
setDT(traceR)
traceR[,':='(wmi2=factor(wallMotionIndex<0.9,levels=c(TRUE,FALSE), 
                labels=c("bad","good")),
             abd2=factor(abdominalCircumference<95, levels=c(TRUE,FALSE), 
                labels=c("slim","fat")))]
traceR[,sex:=as.factor(sex)] # all subgroup variables needs to be factor                
traceR[observationTime==0,observationTime:=1]           
# univariate analysis of smoking in subgroups of age and sex
# Basic model from randomised study - but observed for 12 years
fit_cox <- coxph(Surv(observationTime,dead)~treatment,data=traceR)
sub_cox <- subgroupAnalysis(fit_cox,traceR,treatment="treatment",
  subgroup=c("smoking","sex","wmi2","abd2")) # subgroups as character string
summary(sub_cox)   
}
\seealso{
subgroupAnalysis
}
\author{
Christian Torp-Pedersen
}
