% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/YeoJohnson.R, R/misc.R, R/printing.R
\name{yj_transform}
\alias{yj_transform}
\alias{estimate_yj}
\alias{ellipse_check}
\alias{printer}
\alias{prepare}
\alias{is_trained}
\alias{sel2char}
\alias{print_step}
\title{Internal Functions}
\usage{
yj_transform(x, lambda, ind_neg = NULL, eps = 0.001)

estimate_yj(
  dat,
  limits = c(-5, 5),
  num_unique = 5,
  na_rm = TRUE,
  call = caller_env(2)
)

ellipse_check(...)

printer(
  tr_obj = NULL,
  untr_obj = NULL,
  trained = FALSE,
  width = max(20, options()$width - 30)
)

prepare(x, ...)

is_trained(x)

sel2char(x)

print_step(
  tr_obj = NULL,
  untr_obj = NULL,
  trained = FALSE,
  title = NULL,
  width = max(20, options()$width - 30),
  case_weights = NULL
)
}
\arguments{
\item{x}{A list of selectors}

\item{...}{Arguments pass in from a call to \code{step}}

\item{tr_obj}{A character vector of names that have been
resolved during preparing the recipe (e.g. the \code{columns} object
of \code{\link[=step_log]{step_log()}}).}

\item{untr_obj}{An object of selectors prior to prepping the
recipe (e.g. \code{terms} in most steps).}

\item{trained}{A logical for whether the step has been trained.}

\item{width}{An integer denoting where the output should be wrapped.}

\item{title}{A character, shortly describing the action the step takes.}
}
\value{
If not empty, a list of quosures. If empty, an error is thrown.

\code{NULL}, invisibly.

A logical

A character vector

\code{NULL}, invisibly.
}
\description{
These are not to be used directly by the users.

\code{ellipse_check()} is deprecated. Instead, empty selections should be
supported by all steps.

This internal function is used for printing steps.

This internal function takes a list of selectors (e.g. \code{terms}
in most steps) and returns a character vector version for
printing.

This internal function is used for printing steps.
}
\seealso{
\link{developer_functions}

\link{developer_functions}

\link{developer_functions}
}
\keyword{internal}
