% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnd-abort.R
\name{caller_arg}
\alias{caller_arg}
\title{Find the caller argument for error messages}
\arguments{
\item{arg}{An argument name in the current function.}
}
\description{
\code{caller_arg()} is a variant of \code{substitute()} or \code{\link[=ensym]{ensym()}} for
arguments that reference other arguments. Unlike \code{substitute()}
which returns an expression, \code{caller_arg()} formats the expression
as a single line string which can be included in error messages.
\itemize{
\item When included in an error message, the resulting label should
generally be formatted as argument, for instance using the \code{.arg}
in the cli package.
\item Use \verb{@inheritParams rlang::args_error_context} to document an
\code{arg} or \code{error_arg} argument that takes \code{error_arg()} as default.
}
}
\examples{
arg_checker <- function(x, arg = caller_arg(x), call = caller_env()) {
  cli::cli_abort("{.arg arg} must be a thingy.", call = call)
}

my_function <- function(my_arg) {
  arg_checker(my_arg)
}

try(my_function(NULL))
}
