% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/block.R
\name{roxy_block}
\alias{roxy_block}
\alias{block_has_tags}
\alias{block_get_tags}
\alias{block_get_tag}
\alias{block_get_tag_value}
\title{Blocks}
\usage{
roxy_block(tags, file, line, call, object = NULL)

block_has_tags(block, tags)

block_get_tags(block, tags)

block_get_tag(block, tag)

block_get_tag_value(block, tag)
}
\arguments{
\item{tags}{A list of \link{roxy_tag}s.}

\item{file, line}{Location of the \code{call} (i.e. the line after the last
line of the block).}

\item{call}{Expression associated with block.}

\item{object}{Optionally, the object associated with the block, found
by inspecting/evaluating \code{call}.}

\item{block}{A \code{roxy_block} to manipulate.}

\item{tag}{A single tag name.}
}
\description{
A \code{roxy_block} represents a single roxygen2 block.

The \verb{block_*} functions provide a few helpers for common operations:
\itemize{
\item \code{block_has_tag(blocks, tags)}: does \code{block} contain any of these \code{tags}?
\item \code{block_get_tags(block, tags)}: get all instances of \code{tags}
\item \code{block_get_tag(block, tag)}: get single tag. Returns \code{NULL} if 0,
throws warning if more than 1.
\item \code{block_get_tag_value(block, tag)}: gets \code{val} field from single tag.
}
}
\examples{
# The easiest way to see the structure of a roxy_block is to create one
# using parse_text:
text <- "
  #' This is a title
  #'
  #' @param x,y A number
  #' @export
  f <- function(x, y) x + y
"

# parse_text() returns a list of blocks, so I extract the first
block <- parse_text(text)[[1]]
block
}
\keyword{internal}
