% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string.utilities.R
\name{fixed.pval}
\alias{fixed.pval}
\title{Format a p-value in fixed notation.}
\usage{
fixed.pval(
  pv,
  digits = max(1, getOption("digits") - 2),
  eps = 10^-digits,
  na.form = "NA",
  ...
)
}
\arguments{
\item{pv, digits, eps, na.form, ...}{see \code{\link[=format.pval]{format.pval()}}.}
}
\value{
A character vector.
}
\description{
This is a thin wrapper around \code{\link[=format.pval]{format.pval()}} that guarantees fixed
(not scientific) notation, links (by default) the \code{eps} argument to
the \code{digits} argument and vice versa, and sets \code{nsmall} to equal
\code{digits}.
}
\examples{
pvs <- 10^((0:-12)/2)

# Jointly:
fpf <- fixed.pval(pvs, digits = 3)
fpf
format.pval(pvs, digits = 3) # compare
\dontshow{
stopifnot(all(fpf == c("1.000", "0.316", "0.100", "0.032", "0.010", "0.003", "0.001", "<0.001", "<0.001", "<0.001", "<0.001", "<0.001", "<0.001")))
}
# Individually:
fpf <- sapply(pvs, fixed.pval, digits = 3)
fpf
sapply(pvs, format.pval, digits = 3) # compare
\dontshow{
stopifnot(all(fpf == c("1.000", "0.316", "0.100", "0.032", "0.010", "0.003", "0.001", "<0.001", "<0.001", "<0.001", "<0.001", "<0.001", "<0.001")))
}
# Control eps:
fpf <- sapply(pvs, fixed.pval, eps = 1e-3)
fpf
\dontshow{
stopifnot(all(fpf == c("1.000", "0.316", "0.100", "0.032", "0.010", "0.003", "0.001", "<0.001", "<0.001", "<0.001", "<0.001", "<0.001", "<0.001")))
}
}
