/*
 *	recite - english text speech synthesizer
 *	Copyright (C) 1991, 1992, 1993 Peter Miller.
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 1, or (at your option)
 *	any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * MANIFEST: interface definition for arglex.c
 */

#ifndef ARGLEX_H
#define ARGLEX_H

#include <main.h>

typedef enum arglex_token_t arglex_token_t;
enum arglex_token_t
{
	arglex_token_eoln = -20,
	arglex_token_help,
	arglex_token_number,
	arglex_token_list,
	arglex_token_option,
	arglex_token_stdio,
	arglex_token_string,
	arglex_token_version,
};

typedef struct arglex_value_t arglex_value_t;
struct arglex_value_t
{
	char	*alv_string;
	long	alv_number;
	double	alv_double;
};

typedef struct arglex_table_t arglex_table_t;
struct arglex_table_t
{
	char	*name;
	int	token;
};

extern arglex_token_t arglex_token;
extern arglex_value_t arglex_value;
extern char *progname;

void arglex_init _((int argc, char **argv, arglex_table_t *table));
arglex_token_t arglex _((void));
int arglex_compare _((char *formal, char *actual));

#endif /* ARGLEX_H */
