/*
    This file is part of Rocs.
    Copyright 2004-2011  Tomaz Canabrava <tomaz.canabrava@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef KROSSBACKEND_H
#define KROSSBACKEND_H

#include <QVariant>

#include <kross/core/action.h>
#include "RocsCoreExport.h"

class ROCSLIB_EXPORT KrossBackend
{
public:
    explicit KrossBackend(QVariantList  *dataStructures);
    void setScript(const QString& s);
    void setBackend(const QString& backend);
    Kross::Action* execute();
    void loadFile(const QString& file);

private:
    void javaDefaults();
    void raptorDefaults();
    void pyDefaults();
    void rbDefaults();
    void jsDefaults();
    void luaDefaults();
    void csDefaults();

    QString _backend;
    QString _script;
    QString _autoGeneratedScript;

    QVariantList *_dataStructures;
};

#endif
