
#line 1 "ragel/i18n/ro.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t docstring_content_type_start;
  size_t docstring_content_type_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mGherkinLexer;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->start_col); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 254 "ragel/i18n/ro.c.rl"


/** Data **/

#line 89 "ext/gherkin_lexer_ro/gherkin_lexer_ro.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 12, 1, 13, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 1, 22, 1, 23, 2, 1, 18, 
	2, 4, 5, 2, 13, 0, 2, 14, 
	15, 2, 17, 0, 2, 17, 2, 2, 
	17, 16, 2, 17, 19, 2, 18, 6, 
	2, 18, 7, 2, 18, 8, 2, 18, 
	9, 2, 18, 10, 2, 18, 16, 2, 
	20, 21, 2, 22, 0, 2, 22, 2, 
	2, 22, 16, 2, 22, 19, 3, 3, 
	14, 15, 3, 5, 14, 15, 3, 11, 
	14, 15, 3, 12, 14, 15, 3, 13, 
	14, 15, 3, 14, 15, 18, 3, 17, 
	0, 11, 3, 17, 14, 15, 4, 1, 
	14, 15, 18, 4, 4, 5, 14, 15, 
	4, 17, 0, 14, 15, 5, 17, 0, 
	11, 14, 15
};

static const short _lexer_key_offsets[] = {
	0, 0, 19, 20, 21, 22, 24, 26, 
	44, 45, 46, 47, 49, 51, 56, 61, 
	66, 71, 75, 79, 81, 82, 83, 84, 
	85, 86, 87, 88, 89, 90, 91, 92, 
	93, 94, 95, 96, 101, 108, 113, 114, 
	115, 116, 117, 120, 121, 122, 123, 124, 
	125, 126, 127, 128, 129, 130, 131, 146, 
	148, 150, 152, 170, 171, 175, 176, 177, 
	178, 179, 180, 181, 182, 185, 186, 187, 
	188, 189, 190, 191, 192, 193, 194, 201, 
	203, 205, 207, 211, 213, 215, 217, 219, 
	221, 223, 225, 227, 229, 231, 233, 235, 
	237, 238, 239, 240, 243, 244, 245, 246, 
	247, 248, 249, 250, 251, 252, 253, 254, 
	255, 256, 257, 268, 270, 272, 274, 276, 
	278, 280, 282, 284, 286, 288, 290, 292, 
	294, 296, 298, 300, 302, 304, 306, 308, 
	310, 312, 314, 316, 318, 320, 322, 324, 
	326, 328, 332, 334, 336, 338, 340, 342, 
	344, 346, 348, 350, 352, 354, 357, 359, 
	361, 363, 365, 367, 369, 371, 373, 375, 
	377, 379, 381, 384, 386, 388, 390, 392, 
	393, 396, 397, 398, 399, 400, 401, 402, 
	403, 404, 405, 420, 422, 424, 426, 428, 
	430, 432, 434, 436, 438, 440, 442, 444, 
	446, 448, 450, 452, 454, 456, 458, 460, 
	462, 464, 468, 470, 472, 474, 476, 478, 
	480, 482, 484, 486, 488, 493, 495, 497, 
	499, 501, 503, 505, 507, 511, 513, 515, 
	517, 521, 523, 525, 527, 529, 531, 533, 
	535, 537, 539, 541, 543, 545, 549, 551, 
	553, 555, 557, 559, 561, 563, 565, 567, 
	569, 571, 573, 576, 578, 580, 582, 584, 
	585, 586, 587, 588, 589, 590, 592, 593, 
	594, 595, 596, 597, 598, 599, 600, 601, 
	602, 603, 604, 605, 620, 622, 624, 626, 
	628, 630, 632, 634, 636, 638, 640, 642, 
	644, 646, 648, 650, 652, 654, 656, 658, 
	660, 662, 664, 667, 669, 671, 673, 675, 
	680, 682, 684, 686, 688, 690, 692, 694, 
	698, 700, 702, 704, 708, 710, 712, 714, 
	716, 718, 720, 722, 724, 726, 728, 730, 
	732, 734, 737, 739, 741, 743, 745, 747, 
	749, 753, 759, 762, 764, 770, 788, 790, 
	792, 794, 796, 798, 800, 802, 804, 806, 
	808, 810, 812, 814, 816, 818, 820, 822, 
	824, 826, 829, 831, 833, 835, 837, 842, 
	844, 846, 848, 850, 852, 854, 856, 860, 
	862, 864, 866, 870, 872, 874, 876, 878, 
	880, 882, 884, 886, 888, 890, 892, 894, 
	896, 900, 902, 904, 906, 908, 910, 912, 
	914, 916, 918, 920, 922, 924, 927, 929, 
	931, 933, 935, 936, 937
};

static const char _lexer_trans_keys[] = {
	-59, -56, -17, 10, 32, 34, 35, 37, 
	42, 64, 65, 67, 68, 69, 70, 83, 
	124, 9, 13, -98, 105, 32, 10, 13, 
	10, 13, -59, -56, 10, 32, 34, 35, 
	37, 42, 64, 65, 67, 68, 69, 70, 
	83, 124, 9, 13, -104, 34, 34, 10, 
	13, 10, 13, 10, 32, 34, 9, 13, 
	10, 32, 34, 9, 13, 10, 32, 34, 
	9, 13, 10, 32, 34, 9, 13, 10, 
	32, 9, 13, 10, 32, 9, 13, 10, 
	13, 10, 95, 70, 69, 65, 84, 85, 
	82, 69, 95, 69, 78, 68, 95, 37, 
	13, 32, 64, 9, 10, 9, 10, 13, 
	32, 64, 11, 12, 10, 32, 64, 9, 
	13, 116, 117, 110, 99, -61, 97, 111, 
	-94, 110, 100, 110, 116, 101, 120, 116, 
	58, 10, 10, -59, -56, 10, 32, 35, 
	37, 42, 64, 65, 67, 68, 70, 83, 
	9, 13, -98, 10, 10, 105, 10, 32, 
	-59, -56, 10, 32, 34, 35, 37, 42, 
	64, 65, 67, 68, 69, 70, 83, 124, 
	9, 13, 97, -59, -56, 114, 116, -93, 
	105, 32, 102, 105, 105, -101, 32, 101, 
	105, 120, 101, 109, 112, 108, 101, 58, 
	10, 10, 10, 32, 35, 70, 124, 9, 
	13, 10, 117, 10, 110, 10, 99, -59, 
	-56, 10, 116, -93, 10, 10, 105, 10, 
	111, 10, 110, 10, 97, 10, 108, 10, 
	105, 10, 116, 10, 97, 10, 116, 10, 
	101, 10, 58, -101, 10, 117, 110, 99, 
	-59, -56, 116, -93, 105, 111, 110, 97, 
	108, 105, 116, 97, 116, 101, 58, 10, 
	10, 10, 32, 35, 37, 64, 67, 69, 
	70, 83, 9, 13, 10, 95, 10, 70, 
	10, 69, 10, 65, 10, 84, 10, 85, 
	10, 82, 10, 69, 10, 95, 10, 69, 
	10, 78, 10, 68, 10, 95, 10, 37, 
	10, 111, 10, 110, 10, 116, 10, 101, 
	10, 120, 10, 116, 10, 58, 10, 120, 
	10, 101, 10, 109, 10, 112, 10, 108, 
	10, 101, 10, 117, 10, 110, 10, 99, 
	-59, -56, 10, 116, -93, 10, 10, 105, 
	10, 111, 10, 110, 10, 97, 10, 108, 
	10, 105, 10, 116, 10, 97, 10, 116, 
	-101, 10, 10, 99, 116, 10, 101, 10, 
	110, 10, 97, 10, 114, 10, 105, 10, 
	117, 10, 114, 10, 117, 10, 99, 10, 
	116, 10, 117, 10, 114, -60, 10, 97, 
	-125, 10, 10, 32, 10, 115, 10, 99, 
	-101, 99, 105, 116, 101, 110, 97, 114, 
	105, 117, 58, 10, 10, -59, -56, 10, 
	32, 35, 37, 42, 64, 65, 67, 68, 
	70, 83, 9, 13, -98, 10, 10, 105, 
	10, 32, -104, 10, 10, 95, 10, 70, 
	10, 69, 10, 65, 10, 84, 10, 85, 
	10, 82, 10, 69, 10, 95, 10, 69, 
	10, 78, 10, 68, 10, 95, 10, 37, 
	10, 116, 10, 117, 10, 110, 10, 99, 
	-61, 10, 97, 111, -94, 10, 10, 110, 
	10, 100, 10, 110, 10, 116, 10, 101, 
	10, 120, 10, 116, 10, 58, 10, 97, 
	-59, -56, 10, 114, 116, -93, 10, 10, 
	105, 10, 32, 10, 102, 10, 105, 10, 
	105, -101, 10, 10, 32, 101, 105, 10, 
	117, 10, 110, 10, 99, -59, -56, 10, 
	116, -93, 10, 10, 105, 10, 111, 10, 
	110, 10, 97, 10, 108, 10, 105, 10, 
	116, 10, 97, 10, 116, 10, 101, -101, 
	10, 10, 99, 105, 116, 10, 101, 10, 
	110, 10, 97, 10, 114, 10, 105, 10, 
	117, 10, 114, 10, 117, 10, 99, 10, 
	116, 10, 117, 10, 114, -60, 10, 97, 
	-125, 10, 10, 32, 10, 115, 10, 99, 
	114, 117, 99, 116, 117, 114, -60, 97, 
	-125, 32, 115, 99, 101, 110, 97, 114, 
	105, 117, 58, 10, 10, -59, -56, 10, 
	32, 35, 37, 42, 64, 65, 67, 68, 
	70, 83, 9, 13, -98, 10, 10, 105, 
	10, 32, -104, 10, 10, 95, 10, 70, 
	10, 69, 10, 65, 10, 84, 10, 85, 
	10, 82, 10, 69, 10, 95, 10, 69, 
	10, 78, 10, 68, 10, 95, 10, 37, 
	10, 116, 10, 117, 10, 110, 10, 99, 
	-61, 10, 97, -94, 10, 10, 110, 10, 
	100, 10, 97, -59, -56, 10, 114, 116, 
	-93, 10, 10, 105, 10, 32, 10, 102, 
	10, 105, 10, 105, -101, 10, 10, 32, 
	101, 105, 10, 117, 10, 110, 10, 99, 
	-59, -56, 10, 116, -93, 10, 10, 105, 
	10, 111, 10, 110, 10, 97, 10, 108, 
	10, 105, 10, 116, 10, 97, 10, 116, 
	10, 101, 10, 58, -101, 10, 10, 99, 
	105, 10, 101, 10, 110, 10, 97, 10, 
	114, 10, 105, 10, 117, 32, 124, 9, 
	13, 10, 32, 92, 124, 9, 13, 10, 
	92, 124, 10, 92, 10, 32, 92, 124, 
	9, 13, -59, -56, 10, 32, 34, 35, 
	37, 42, 64, 65, 67, 68, 69, 70, 
	83, 124, 9, 13, -104, 10, 10, 95, 
	10, 70, 10, 69, 10, 65, 10, 84, 
	10, 85, 10, 82, 10, 69, 10, 95, 
	10, 69, 10, 78, 10, 68, 10, 95, 
	10, 37, 10, 116, 10, 117, 10, 110, 
	10, 99, -61, 10, 97, -94, 10, 10, 
	110, 10, 100, 10, 97, -59, -56, 10, 
	114, 116, -93, 10, 10, 105, 10, 32, 
	10, 102, 10, 105, 10, 105, -101, 10, 
	10, 32, 101, 105, 10, 117, 10, 110, 
	10, 99, -59, -56, 10, 116, -93, 10, 
	10, 105, 10, 111, 10, 110, 10, 97, 
	10, 108, 10, 105, 10, 116, 10, 97, 
	10, 116, 10, 101, 10, 58, -101, 10, 
	10, 99, 105, 116, 10, 101, 10, 110, 
	10, 97, 10, 114, 10, 105, 10, 117, 
	10, 114, 10, 117, 10, 99, 10, 116, 
	10, 117, 10, 114, -60, 10, 97, -125, 
	10, 10, 32, 10, 115, 10, 99, -69, 
	-65, 0
};

static const char _lexer_single_lengths[] = {
	0, 17, 1, 1, 1, 2, 2, 16, 
	1, 1, 1, 2, 2, 3, 3, 3, 
	3, 2, 2, 2, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 3, 5, 3, 1, 1, 
	1, 1, 3, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 13, 2, 
	2, 2, 16, 1, 4, 1, 1, 1, 
	1, 1, 1, 1, 3, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 5, 2, 
	2, 2, 4, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	1, 1, 1, 3, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 9, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 4, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 2, 1, 
	3, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 13, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 4, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 5, 2, 2, 2, 
	2, 2, 2, 2, 4, 2, 2, 2, 
	4, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 4, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 2, 1, 
	1, 1, 1, 1, 1, 2, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 13, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 2, 5, 
	2, 2, 2, 2, 2, 2, 2, 4, 
	2, 2, 2, 4, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 3, 2, 2, 2, 2, 2, 2, 
	2, 4, 3, 2, 4, 16, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 3, 2, 2, 2, 2, 5, 2, 
	2, 2, 2, 2, 2, 2, 4, 2, 
	2, 2, 4, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	4, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 3, 2, 2, 
	2, 2, 1, 1, 0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 1, 1, 1, 
	1, 1, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 1, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 0, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 1, 0, 0, 1, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0
};

static const short _lexer_index_offsets[] = {
	0, 0, 19, 21, 23, 25, 28, 31, 
	49, 51, 53, 55, 58, 61, 66, 71, 
	76, 81, 85, 89, 92, 94, 96, 98, 
	100, 102, 104, 106, 108, 110, 112, 114, 
	116, 118, 120, 122, 127, 134, 139, 141, 
	143, 145, 147, 151, 153, 155, 157, 159, 
	161, 163, 165, 167, 169, 171, 173, 188, 
	191, 194, 197, 215, 217, 222, 224, 226, 
	228, 230, 232, 234, 236, 240, 242, 244, 
	246, 248, 250, 252, 254, 256, 258, 265, 
	268, 271, 274, 279, 282, 285, 288, 291, 
	294, 297, 300, 303, 306, 309, 312, 315, 
	318, 320, 322, 324, 328, 330, 332, 334, 
	336, 338, 340, 342, 344, 346, 348, 350, 
	352, 354, 356, 367, 370, 373, 376, 379, 
	382, 385, 388, 391, 394, 397, 400, 403, 
	406, 409, 412, 415, 418, 421, 424, 427, 
	430, 433, 436, 439, 442, 445, 448, 451, 
	454, 457, 462, 465, 468, 471, 474, 477, 
	480, 483, 486, 489, 492, 495, 499, 502, 
	505, 508, 511, 514, 517, 520, 523, 526, 
	529, 532, 535, 539, 542, 545, 548, 551, 
	553, 557, 559, 561, 563, 565, 567, 569, 
	571, 573, 575, 590, 593, 596, 599, 602, 
	605, 608, 611, 614, 617, 620, 623, 626, 
	629, 632, 635, 638, 641, 644, 647, 650, 
	653, 656, 661, 664, 667, 670, 673, 676, 
	679, 682, 685, 688, 691, 697, 700, 703, 
	706, 709, 712, 715, 718, 723, 726, 729, 
	732, 737, 740, 743, 746, 749, 752, 755, 
	758, 761, 764, 767, 770, 773, 778, 781, 
	784, 787, 790, 793, 796, 799, 802, 805, 
	808, 811, 814, 818, 821, 824, 827, 830, 
	832, 834, 836, 838, 840, 842, 845, 847, 
	849, 851, 853, 855, 857, 859, 861, 863, 
	865, 867, 869, 871, 886, 889, 892, 895, 
	898, 901, 904, 907, 910, 913, 916, 919, 
	922, 925, 928, 931, 934, 937, 940, 943, 
	946, 949, 952, 956, 959, 962, 965, 968, 
	974, 977, 980, 983, 986, 989, 992, 995, 
	1000, 1003, 1006, 1009, 1014, 1017, 1020, 1023, 
	1026, 1029, 1032, 1035, 1038, 1041, 1044, 1047, 
	1050, 1053, 1057, 1060, 1063, 1066, 1069, 1072, 
	1075, 1079, 1085, 1089, 1092, 1098, 1116, 1119, 
	1122, 1125, 1128, 1131, 1134, 1137, 1140, 1143, 
	1146, 1149, 1152, 1155, 1158, 1161, 1164, 1167, 
	1170, 1173, 1177, 1180, 1183, 1186, 1189, 1195, 
	1198, 1201, 1204, 1207, 1210, 1213, 1216, 1221, 
	1224, 1227, 1230, 1235, 1238, 1241, 1244, 1247, 
	1250, 1253, 1256, 1259, 1262, 1265, 1268, 1271, 
	1274, 1279, 1282, 1285, 1288, 1291, 1294, 1297, 
	1300, 1303, 1306, 1309, 1312, 1315, 1319, 1322, 
	1325, 1328, 1331, 1333, 1335
};

static const short _lexer_trans_targs[] = {
	2, 8, 418, 7, 7, 9, 19, 21, 
	4, 35, 38, 42, 59, 69, 96, 176, 
	344, 7, 0, 3, 0, 4, 0, 5, 
	0, 7, 20, 6, 7, 20, 6, 2, 
	8, 7, 7, 9, 19, 21, 4, 35, 
	38, 42, 59, 69, 96, 176, 344, 7, 
	0, 3, 0, 10, 0, 11, 0, 13, 
	12, 12, 13, 12, 12, 14, 14, 15, 
	14, 14, 14, 14, 15, 14, 14, 14, 
	14, 16, 14, 14, 14, 14, 17, 14, 
	14, 7, 18, 18, 0, 7, 18, 18, 
	0, 7, 20, 19, 7, 0, 22, 0, 
	23, 0, 24, 0, 25, 0, 26, 0, 
	27, 0, 28, 0, 29, 0, 30, 0, 
	31, 0, 32, 0, 33, 0, 34, 0, 
	420, 0, 0, 0, 0, 0, 36, 37, 
	7, 37, 37, 35, 36, 36, 7, 37, 
	35, 37, 0, 39, 0, 40, 0, 41, 
	0, 3, 0, 43, 44, 46, 0, 44, 
	0, 45, 0, 4, 0, 47, 0, 48, 
	0, 49, 0, 50, 0, 51, 0, 52, 
	0, 54, 53, 54, 53, 55, 350, 54, 
	54, 7, 351, 57, 7, 365, 369, 373, 
	383, 400, 54, 53, 56, 54, 53, 54, 
	57, 53, 54, 58, 53, 2, 8, 7, 
	7, 9, 19, 21, 4, 35, 38, 42, 
	59, 69, 96, 176, 344, 7, 0, 60, 
	0, 61, 67, 4, 68, 0, 62, 0, 
	63, 0, 64, 0, 65, 0, 66, 0, 
	44, 0, 62, 0, 64, 63, 63, 0, 
	70, 0, 71, 0, 72, 0, 73, 0, 
	74, 0, 75, 0, 76, 0, 78, 77, 
	78, 77, 78, 78, 7, 79, 7, 78, 
	77, 78, 80, 77, 78, 81, 77, 78, 
	82, 77, 83, 95, 78, 84, 77, 84, 
	78, 77, 78, 85, 77, 78, 86, 77, 
	78, 87, 77, 78, 88, 77, 78, 89, 
	77, 78, 90, 77, 78, 91, 77, 78, 
	92, 77, 78, 93, 77, 78, 94, 77, 
	78, 58, 77, 84, 78, 77, 97, 0, 
	98, 0, 99, 0, 100, 175, 101, 0, 
	101, 0, 102, 0, 103, 0, 104, 0, 
	105, 0, 106, 0, 107, 0, 108, 0, 
	109, 0, 110, 0, 111, 0, 112, 0, 
	114, 113, 114, 113, 114, 114, 7, 115, 
	7, 129, 136, 142, 157, 114, 113, 114, 
	116, 113, 114, 117, 113, 114, 118, 113, 
	114, 119, 113, 114, 120, 113, 114, 121, 
	113, 114, 122, 113, 114, 123, 113, 114, 
	124, 113, 114, 125, 113, 114, 126, 113, 
	114, 127, 113, 114, 128, 113, 114, 7, 
	113, 114, 130, 113, 114, 131, 113, 114, 
	132, 113, 114, 133, 113, 114, 134, 113, 
	114, 135, 113, 114, 58, 113, 114, 137, 
	113, 114, 138, 113, 114, 139, 113, 114, 
	140, 113, 114, 141, 113, 114, 135, 113, 
	114, 143, 113, 114, 144, 113, 114, 145, 
	113, 146, 156, 114, 147, 113, 147, 114, 
	113, 114, 148, 113, 114, 149, 113, 114, 
	150, 113, 114, 151, 113, 114, 152, 113, 
	114, 153, 113, 114, 154, 113, 114, 155, 
	113, 114, 141, 113, 147, 114, 113, 114, 
	158, 164, 113, 114, 159, 113, 114, 160, 
	113, 114, 161, 113, 114, 162, 113, 114, 
	163, 113, 114, 135, 113, 114, 165, 113, 
	114, 166, 113, 114, 167, 113, 114, 168, 
	113, 114, 169, 113, 114, 170, 113, 171, 
	114, 172, 113, 172, 114, 113, 114, 173, 
	113, 114, 174, 113, 114, 158, 113, 101, 
	0, 177, 4, 263, 0, 178, 0, 179, 
	0, 180, 0, 181, 0, 182, 0, 183, 
	0, 184, 0, 186, 185, 186, 185, 187, 
	190, 186, 186, 7, 191, 189, 7, 205, 
	209, 219, 229, 245, 186, 185, 188, 186, 
	185, 186, 189, 185, 186, 58, 185, 188, 
	186, 185, 186, 192, 185, 186, 193, 185, 
	186, 194, 185, 186, 195, 185, 186, 196, 
	185, 186, 197, 185, 186, 198, 185, 186, 
	199, 185, 186, 200, 185, 186, 201, 185, 
	186, 202, 185, 186, 203, 185, 186, 204, 
	185, 186, 7, 185, 186, 206, 185, 186, 
	207, 185, 186, 208, 185, 186, 188, 185, 
	210, 186, 211, 213, 185, 211, 186, 185, 
	186, 212, 185, 186, 189, 185, 186, 214, 
	185, 186, 215, 185, 186, 216, 185, 186, 
	217, 185, 186, 218, 185, 186, 58, 185, 
	186, 220, 185, 221, 227, 186, 189, 228, 
	185, 222, 186, 185, 186, 223, 185, 186, 
	224, 185, 186, 225, 185, 186, 226, 185, 
	186, 211, 185, 222, 186, 185, 186, 224, 
	223, 223, 185, 186, 230, 185, 186, 231, 
	185, 186, 232, 185, 233, 244, 186, 234, 
	185, 234, 186, 185, 186, 235, 185, 186, 
	236, 185, 186, 237, 185, 186, 238, 185, 
	186, 239, 185, 186, 240, 185, 186, 241, 
	185, 186, 242, 185, 186, 243, 185, 186, 
	218, 185, 234, 186, 185, 186, 246, 189, 
	252, 185, 186, 247, 185, 186, 248, 185, 
	186, 249, 185, 186, 250, 185, 186, 251, 
	185, 186, 218, 185, 186, 253, 185, 186, 
	254, 185, 186, 255, 185, 186, 256, 185, 
	186, 257, 185, 186, 258, 185, 259, 186, 
	260, 185, 260, 186, 185, 186, 261, 185, 
	186, 262, 185, 186, 246, 185, 264, 0, 
	265, 0, 266, 0, 267, 0, 268, 0, 
	269, 0, 270, 271, 0, 271, 0, 272, 
	0, 273, 0, 274, 0, 275, 0, 276, 
	0, 277, 0, 278, 0, 279, 0, 280, 
	0, 281, 0, 283, 282, 283, 282, 284, 
	287, 283, 283, 7, 288, 286, 7, 302, 
	306, 310, 320, 337, 283, 282, 285, 283, 
	282, 283, 286, 282, 283, 58, 282, 285, 
	283, 282, 283, 289, 282, 283, 290, 282, 
	283, 291, 282, 283, 292, 282, 283, 293, 
	282, 283, 294, 282, 283, 295, 282, 283, 
	296, 282, 283, 297, 282, 283, 298, 282, 
	283, 299, 282, 283, 300, 282, 283, 301, 
	282, 283, 7, 282, 283, 303, 282, 283, 
	304, 282, 283, 305, 282, 283, 285, 282, 
	307, 283, 308, 282, 308, 283, 282, 283, 
	309, 282, 283, 286, 282, 283, 311, 282, 
	312, 318, 283, 286, 319, 282, 313, 283, 
	282, 283, 314, 282, 283, 315, 282, 283, 
	316, 282, 283, 317, 282, 283, 308, 282, 
	313, 283, 282, 283, 315, 314, 314, 282, 
	283, 321, 282, 283, 322, 282, 283, 323, 
	282, 324, 336, 283, 325, 282, 325, 283, 
	282, 283, 326, 282, 283, 327, 282, 283, 
	328, 282, 283, 329, 282, 283, 330, 282, 
	283, 331, 282, 283, 332, 282, 283, 333, 
	282, 283, 334, 282, 283, 335, 282, 283, 
	58, 282, 325, 283, 282, 283, 338, 286, 
	282, 283, 339, 282, 283, 340, 282, 283, 
	341, 282, 283, 342, 282, 283, 343, 282, 
	283, 335, 282, 344, 345, 344, 0, 349, 
	348, 347, 345, 348, 346, 0, 347, 345, 
	346, 0, 347, 346, 349, 348, 347, 345, 
	348, 346, 2, 8, 349, 349, 9, 19, 
	21, 4, 35, 38, 42, 59, 69, 96, 
	176, 344, 349, 0, 56, 54, 53, 54, 
	352, 53, 54, 353, 53, 54, 354, 53, 
	54, 355, 53, 54, 356, 53, 54, 357, 
	53, 54, 358, 53, 54, 359, 53, 54, 
	360, 53, 54, 361, 53, 54, 362, 53, 
	54, 363, 53, 54, 364, 53, 54, 7, 
	53, 54, 366, 53, 54, 367, 53, 54, 
	368, 53, 54, 56, 53, 370, 54, 371, 
	53, 371, 54, 53, 54, 372, 53, 54, 
	57, 53, 54, 374, 53, 375, 381, 54, 
	57, 382, 53, 376, 54, 53, 54, 377, 
	53, 54, 378, 53, 54, 379, 53, 54, 
	380, 53, 54, 371, 53, 376, 54, 53, 
	54, 378, 377, 377, 53, 54, 384, 53, 
	54, 385, 53, 54, 386, 53, 387, 399, 
	54, 388, 53, 388, 54, 53, 54, 389, 
	53, 54, 390, 53, 54, 391, 53, 54, 
	392, 53, 54, 393, 53, 54, 394, 53, 
	54, 395, 53, 54, 396, 53, 54, 397, 
	53, 54, 398, 53, 54, 58, 53, 388, 
	54, 53, 54, 401, 57, 407, 53, 54, 
	402, 53, 54, 403, 53, 54, 404, 53, 
	54, 405, 53, 54, 406, 53, 54, 398, 
	53, 54, 408, 53, 54, 409, 53, 54, 
	410, 53, 54, 411, 53, 54, 412, 53, 
	54, 413, 53, 414, 54, 415, 53, 415, 
	54, 53, 54, 416, 53, 54, 417, 53, 
	54, 401, 53, 419, 0, 7, 0, 0, 
	0
};

static const unsigned char _lexer_trans_actions[] = {
	29, 29, 0, 54, 0, 5, 1, 0, 
	29, 1, 29, 29, 29, 29, 29, 29, 
	35, 0, 43, 0, 43, 0, 43, 0, 
	43, 149, 126, 57, 110, 23, 0, 29, 
	29, 54, 0, 5, 1, 0, 29, 1, 
	29, 29, 29, 29, 29, 29, 35, 0, 
	43, 0, 43, 0, 43, 0, 43, 139, 
	48, 9, 106, 11, 0, 134, 45, 45, 
	45, 3, 122, 33, 33, 33, 0, 122, 
	33, 33, 33, 0, 122, 33, 0, 33, 
	0, 102, 7, 7, 43, 54, 0, 0, 
	43, 114, 25, 0, 54, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 43, 43, 43, 43, 0, 27, 
	118, 27, 27, 51, 27, 0, 54, 0, 
	1, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 0, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 144, 57, 54, 0, 84, 84, 54, 
	0, 72, 33, 84, 72, 84, 84, 84, 
	84, 84, 0, 0, 0, 54, 0, 54, 
	0, 0, 54, 15, 0, 63, 63, 130, 
	31, 60, 57, 31, 63, 57, 63, 63, 
	63, 63, 63, 63, 66, 31, 43, 0, 
	43, 0, 0, 0, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 0, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 144, 57, 
	54, 0, 54, 0, 81, 84, 81, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 0, 54, 0, 0, 0, 
	54, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 21, 0, 0, 54, 0, 0, 43, 
	0, 43, 0, 43, 0, 0, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	144, 57, 54, 0, 54, 0, 69, 33, 
	69, 84, 84, 84, 84, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 13, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 13, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 0, 54, 0, 0, 0, 54, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 0, 54, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	43, 0, 0, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 144, 57, 54, 0, 84, 
	84, 54, 0, 75, 33, 84, 75, 84, 
	84, 84, 84, 84, 0, 0, 0, 54, 
	0, 54, 0, 0, 54, 17, 0, 0, 
	54, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 17, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 0, 0, 54, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 17, 0, 
	54, 0, 0, 0, 0, 54, 0, 0, 
	0, 0, 54, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 54, 0, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 0, 54, 0, 
	0, 0, 54, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 54, 0, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 0, 54, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 144, 57, 54, 0, 84, 
	84, 54, 0, 78, 33, 84, 78, 84, 
	84, 84, 84, 84, 0, 0, 0, 54, 
	0, 54, 0, 0, 54, 19, 0, 0, 
	54, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 19, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 0, 54, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 0, 54, 0, 0, 0, 0, 54, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 54, 0, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 0, 54, 0, 0, 0, 54, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	19, 0, 0, 54, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 0, 0, 43, 54, 
	37, 37, 87, 37, 37, 43, 0, 39, 
	0, 43, 0, 0, 54, 0, 0, 39, 
	0, 0, 96, 96, 54, 0, 93, 90, 
	41, 96, 90, 96, 96, 96, 96, 96, 
	96, 99, 0, 43, 0, 54, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 15, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 0, 54, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 0, 54, 
	0, 0, 0, 0, 54, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	54, 0, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 0, 
	54, 0, 0, 0, 54, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 15, 0, 0, 
	54, 0, 54, 0, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 0, 
	54, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 43, 0, 43, 0, 
	0
};

static const unsigned char _lexer_eof_actions[] = {
	0, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43
};

static const int lexer_start = 1;
static const int lexer_first_final = 420;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 258 "ragel/i18n/ro.c.rl"

static VALUE 
unindent(VALUE con, int start_col)
{
  VALUE re;
  /* Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters */
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  re = rb_reg_regcomp(rb_str_new2(pat));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));

  return Qnil;

}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int start_col)
{
  VALUE split;
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);
  
  split = rb_str_split(con, "\n");

  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( "\n" ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("rstrip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}
static void 
store_docstring_content(VALUE listener, 
          int start_col, 
          const char *type_at, size_t type_length,
          const char *at, size_t length, 
          int current_line)
{
  VALUE re2;
  VALUE unescape_escaped_quotes;
  VALUE con = ENCODED_STR_NEW(at, length);
  VALUE con_type = ENCODED_STR_NEW(type_at, type_length);

  unindent(con, start_col);

  re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con_type, rb_intern("strip!"), 0);
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("doc_string"), 3, con_type, con, INT2FIX(current_line));
}
static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/cucumber/gherkin/lexingerror for more information.", line, at);
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->docstring_content_type_start = 0;
  lexer->docstring_content_type_end = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  lexer_state *lxr; 
  rb_iv_set(self, "@listener", listener);
  
  lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input)
{
  VALUE input_copy;
  char *data;
  size_t len;
  VALUE listener = rb_iv_get(self, "@listener");

  lexer_state *lexer;
  lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  data = RSTRING_PTR(input_copy);
  len = RSTRING_LEN(input_copy);
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 1031 "ext/gherkin_lexer_ro/gherkin_lexer_ro.c"
	{
	cs = lexer_start;
	}

#line 425 "ragel/i18n/ro.c.rl"
    
#line 1038 "ext/gherkin_lexer_ro/gherkin_lexer_ro.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (unsigned int)(_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += (unsigned int)((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 83 "ragel/i18n/ro.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
    lexer->start_col = lexer->content_start - lexer->last_newline - (lexer->keyword_end - lexer->keyword_start) + 2;
  }
	break;
	case 1:
#line 89 "ragel/i18n/ro.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 93 "ragel/i18n/ro.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 98 "ragel/i18n/ro.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));
    int type_len = LEN(docstring_content_type_start, PTR_TO(docstring_content_type_end));

    if (len < 0) len = 0;
    if (type_len < 0) len = 0;

    store_docstring_content(listener, lexer->start_col, PTR_TO(docstring_content_type_start), type_len, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 108 "ragel/i18n/ro.c.rl"
	{ 
    MARK(docstring_content_type_start, p);
  }
	break;
	case 5:
#line 112 "ragel/i18n/ro.c.rl"
	{ 
    MARK(docstring_content_type_end, p);
  }
	break;
	case 6:
#line 116 "ragel/i18n/ro.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 7:
#line 120 "ragel/i18n/ro.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 8:
#line 124 "ragel/i18n/ro.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 9:
#line 128 "ragel/i18n/ro.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 10:
#line 132 "ragel/i18n/ro.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 11:
#line 136 "ragel/i18n/ro.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 12:
#line 143 "ragel/i18n/ro.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 13:
#line 148 "ragel/i18n/ro.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 14:
#line 153 "ragel/i18n/ro.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 15:
#line 158 "ragel/i18n/ro.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 16:
#line 162 "ragel/i18n/ro.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 17:
#line 168 "ragel/i18n/ro.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 18:
#line 175 "ragel/i18n/ro.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 19:
#line 179 "ragel/i18n/ro.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 20:
#line 185 "ragel/i18n/ro.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 21:
#line 189 "ragel/i18n/ro.c.rl"
	{
    VALUE re_pipe, re_newline, re_backslash;
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    re_newline   = rb_reg_regcomp(rb_str_new2("\\\\n"));
    re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_newline,   rb_str_new2("\n"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 22:
#line 203 "ragel/i18n/ro.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 23:
#line 207 "ragel/i18n/ro.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1328 "ext/gherkin_lexer_ro/gherkin_lexer_ro.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 23:
#line 207 "ragel/i18n/ro.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1391 "ext/gherkin_lexer_ro/gherkin_lexer_ro.c"
		}
	}
	}

	_out: {}
	}

#line 426 "ragel/i18n/ro.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    /* Reset lexer by re-initializing the whole thing */
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_ro()
{
  mGherkin = rb_define_module("Gherkin");
  mGherkinLexer = rb_define_module_under(mGherkin, "Lexer");
  rb_eGherkinLexingError = rb_const_get(mGherkinLexer, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "Ro", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 1);
}

