/**
	@license GNU GPLv2
	PROJECT "db_table"
	Copyright  2006 Danilo Cicerone

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software Foundation,
	Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
*/

/**
	@file db_table.h
	@author Danilo Cicerone info@digitazero.org
	@date 2006-12-05
	@version 0.2.2
*/

#ifndef DB_TABLE_H
#define DB_TABLE_H

#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/fl_draw.H>
#include "Fl_Table_Row.H"

#include <string>
#include <vector>

#include <stdio.h>
#include <string.h>

using namespace std;

class DB_Table : public Fl_Table_Row
{
	public:
		DB_Table(int x, int y, int w, int h, const char *l=0);
		~DB_Table();
		vector<string> xTable;
		vector<string> xTable_Header;

	protected:
		void draw_cell(TableContext context, int R=0, int C=0, int X=0, int Y=0, 
			int W=0, int H=0);
};

#endif
