/* gtkdoccommentscanner.c generated by valac, the Vala compiler
 * generated from gtkdoccommentscanner.vala, do not modify */

/* gtkcommentscanner.vala
 *
 * Copyright (C) 2011  Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */


#include <glib.h>
#include <glib-object.h>
#include "valadoc.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <gobject/gvaluecollector.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
typedef struct _ValadocGtkdocParamSpecToken ValadocGtkdocParamSpecToken;
#define _valadoc_gtkdoc_token_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_gtkdoc_token_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _ValadocGtkdocParamSpecScanner ValadocGtkdocParamSpecScanner;

struct _ValadocGtkdocParamSpecToken {
	GParamSpec parent_instance;
};

struct _ValadocGtkdocScannerPrivate {
	const gchar* content;
	const gchar* pos;
	gint column;
	gint line;
	ValadocGtkdocToken* tmp_token;
};

struct _ValadocGtkdocParamSpecScanner {
	GParamSpec parent_instance;
};


static gpointer valadoc_gtkdoc_token_parent_class = NULL;
static gpointer valadoc_gtkdoc_scanner_parent_class = NULL;

static void valadoc_gtkdoc_token_finalize (ValadocGtkdocToken * obj);
#define VALADOC_GTKDOC_SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALADOC_GTKDOC_TYPE_SCANNER, ValadocGtkdocScannerPrivate))
static inline gunichar valadoc_gtkdoc_scanner_next_char (ValadocGtkdocScanner* self);
static inline gunichar valadoc_gtkdoc_scanner_get (ValadocGtkdocScanner* self);
static inline gboolean valadoc_gtkdoc_scanner_letter (ValadocGtkdocScanner* self,
                                        gunichar c);
static inline gboolean valadoc_gtkdoc_scanner_letter_or_number (ValadocGtkdocScanner* self,
                                                  gunichar c);
static inline gboolean valadoc_gtkdoc_scanner_space (ValadocGtkdocScanner* self,
                                       gunichar c);
static inline gboolean valadoc_gtkdoc_scanner_space_or_newline (ValadocGtkdocScanner* self,
                                                  gunichar c);
static inline gint valadoc_gtkdoc_scanner_offset (ValadocGtkdocScanner* self,
                                    const gchar* a,
                                    const gchar* b);
static inline gint valadoc_gtkdoc_scanner_vararg_prefix (ValadocGtkdocScanner* self);
static inline gint valadoc_gtkdoc_scanner_id_prefix (ValadocGtkdocScanner* self);
static inline gint valadoc_gtkdoc_scanner_g_id_prefix (ValadocGtkdocScanner* self);
static inline gint valadoc_gtkdoc_scanner_skip_spaces_and_newlines (ValadocGtkdocScanner* self);
static inline ValadocGtkdocToken* valadoc_gtkdoc_scanner_function_prefix (ValadocGtkdocScanner* self);
static ValadocGtkdocToken* valadoc_gtkdoc_scanner_space_prefix (ValadocGtkdocScanner* self);
static inline ValadocGtkdocToken* valadoc_gtkdoc_scanner_gtkdoc_symbolic_link_prefix (ValadocGtkdocScanner* self,
                                                                        gunichar c,
                                                                        ValadocGtkdocTokenType type);
static inline ValadocGtkdocToken* valadoc_gtkdoc_scanner_gtkdoc_property_prefix (ValadocGtkdocScanner* self);
static inline ValadocGtkdocToken* valadoc_gtkdoc_scanner_gtkdoc_signal_prefix (ValadocGtkdocScanner* self);
static inline ValadocGtkdocToken* valadoc_gtkdoc_scanner_gtkdoc_const_prefix (ValadocGtkdocScanner* self);
static inline ValadocGtkdocToken* valadoc_gtkdoc_scanner_gtkdoc_param_prefix (ValadocGtkdocScanner* self);
static inline ValadocGtkdocToken* valadoc_gtkdoc_scanner_gtkdoc_type_prefix (ValadocGtkdocScanner* self);
static inline ValadocGtkdocToken* valadoc_gtkdoc_scanner_xml_prefix (ValadocGtkdocScanner* self);
static ValadocGtkdocToken* valadoc_gtkdoc_scanner_newline_prefix (ValadocGtkdocScanner* self);
static ValadocGtkdocToken* valadoc_gtkdoc_scanner_eof_prefix (ValadocGtkdocScanner* self);
static ValadocGtkdocToken* valadoc_gtkdoc_scanner_word_prefix (ValadocGtkdocScanner* self);
static ValadocGtkdocToken* valadoc_gtkdoc_scanner_gtkdoc_source_open_prefix (ValadocGtkdocScanner* self);
static ValadocGtkdocToken* valadoc_gtkdoc_scanner_gtkdoc_source_close_prefix (ValadocGtkdocScanner* self);
static void valadoc_gtkdoc_scanner_finalize (ValadocGtkdocScanner * obj);


GType
valadoc_gtkdoc_token_type_get_type (void)
{
	static volatile gsize valadoc_gtkdoc_token_type_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_gtkdoc_token_type_type_id__volatile)) {
		static const GEnumValue values[] = {{VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN, "VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN", "xml-open"}, {VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE, "VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE", "xml-close"}, {VALADOC_GTKDOC_TOKEN_TYPE_XML_COMMENT, "VALADOC_GTKDOC_TOKEN_TYPE_XML_COMMENT", "xml-comment"}, {VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_FUNCTION, "VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_FUNCTION", "gtkdoc-function"}, {VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_CONST, "VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_CONST", "gtkdoc-const"}, {VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_TYPE, "VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_TYPE", "gtkdoc-type"}, {VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAM, "VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAM", "gtkdoc-param"}, {VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SOURCE_OPEN, "VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SOURCE_OPEN", "gtkdoc-source-open"}, {VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SOURCE_CLOSE, "VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SOURCE_CLOSE", "gtkdoc-source-close"}, {VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SIGNAL, "VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SIGNAL", "gtkdoc-signal"}, {VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PROPERTY, "VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PROPERTY", "gtkdoc-property"}, {VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAGRAPH, "VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAGRAPH", "gtkdoc-paragraph"}, {VALADOC_GTKDOC_TOKEN_TYPE_NEWLINE, "VALADOC_GTKDOC_TOKEN_TYPE_NEWLINE", "newline"}, {VALADOC_GTKDOC_TOKEN_TYPE_SPACE, "VALADOC_GTKDOC_TOKEN_TYPE_SPACE", "space"}, {VALADOC_GTKDOC_TOKEN_TYPE_WORD, "VALADOC_GTKDOC_TOKEN_TYPE_WORD", "word"}, {VALADOC_GTKDOC_TOKEN_TYPE_EOF, "VALADOC_GTKDOC_TOKEN_TYPE_EOF", "eof"}, {0, NULL, NULL}};
		GType valadoc_gtkdoc_token_type_type_id;
		valadoc_gtkdoc_token_type_type_id = g_enum_register_static ("ValadocGtkdocTokenType", values);
		g_once_init_leave (&valadoc_gtkdoc_token_type_type_id__volatile, valadoc_gtkdoc_token_type_type_id);
	}
	return valadoc_gtkdoc_token_type_type_id__volatile;
}


static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}


ValadocGtkdocToken*
valadoc_gtkdoc_token_construct (GType object_type,
                                ValadocGtkdocTokenType type,
                                const gchar* content,
                                ValaHashMap* attributes,
                                const gchar* start,
                                gint length,
                                gint line,
                                gint first_column,
                                gint last_column)
{
	ValadocGtkdocToken* self = NULL;
	ValaHashMap* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (content != NULL, NULL);
	g_return_val_if_fail (start != NULL, NULL);
	self = (ValadocGtkdocToken*) g_type_create_instance (object_type);
	_tmp0_ = _vala_map_ref0 (attributes);
	_vala_map_unref0 (self->attributes);
	self->attributes = _tmp0_;
	_tmp1_ = g_strdup (content);
	_g_free0 (self->content);
	self->content = _tmp1_;
	self->length = length;
	self->start = start;
	self->type = type;
	self->line = line;
	self->first_column = first_column;
	self->last_column = last_column;
	return self;
}


ValadocGtkdocToken*
valadoc_gtkdoc_token_new (ValadocGtkdocTokenType type,
                          const gchar* content,
                          ValaHashMap* attributes,
                          const gchar* start,
                          gint length,
                          gint line,
                          gint first_column,
                          gint last_column)
{
	return valadoc_gtkdoc_token_construct (VALADOC_GTKDOC_TYPE_TOKEN, type, content, attributes, start, length, line, first_column, last_column);
}


gchar*
valadoc_gtkdoc_token_to_string (ValadocGtkdocToken* self)
{
	gchar* result = NULL;
	ValadocGtkdocTokenType _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->type;
	switch (_tmp0_) {
		case VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN:
		{
			const gchar* _tmp1_;
			gchar* _tmp2_;
			_tmp1_ = self->content;
			_tmp2_ = g_strdup_printf ("`<%s>'", _tmp1_);
			result = _tmp2_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE:
		{
			const gchar* _tmp3_;
			gchar* _tmp4_;
			_tmp3_ = self->content;
			_tmp4_ = g_strdup_printf ("`</%s>'", _tmp3_);
			result = _tmp4_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_XML_COMMENT:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("<XML-COMMENT>");
			result = _tmp5_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_FUNCTION:
		{
			const gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp6_ = self->content;
			_tmp7_ = g_strdup_printf ("`%s ()'", _tmp6_);
			result = _tmp7_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_CONST:
		{
			const gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp8_ = self->content;
			_tmp9_ = g_strdup_printf ("`%%%s'", _tmp8_);
			result = _tmp9_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_TYPE:
		{
			const gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp10_ = self->content;
			_tmp11_ = g_strdup_printf ("`#%s'", _tmp10_);
			result = _tmp11_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAM:
		{
			gchar* _tmp12_;
			_tmp12_ = g_strdup ("<GTKDOC-PARAM>");
			result = _tmp12_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SOURCE_OPEN:
		{
			gchar* _tmp13_;
			_tmp13_ = g_strdup ("[|");
			result = _tmp13_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SOURCE_CLOSE:
		{
			gchar* _tmp14_;
			_tmp14_ = g_strdup ("|]");
			result = _tmp14_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SIGNAL:
		{
			const gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp15_ = self->content;
			_tmp16_ = g_strdup_printf ("`::%s'", _tmp15_);
			result = _tmp16_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PROPERTY:
		{
			const gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp17_ = self->content;
			_tmp18_ = g_strdup_printf ("`:%s'", _tmp17_);
			result = _tmp18_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAGRAPH:
		{
			gchar* _tmp19_;
			_tmp19_ = g_strdup ("<GKTDOC-PARAGRAPH>");
			result = _tmp19_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_NEWLINE:
		{
			gchar* _tmp20_;
			_tmp20_ = g_strdup ("<NEWLNIE>");
			result = _tmp20_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_SPACE:
		{
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("<SPACE>");
			result = _tmp21_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_WORD:
		{
			const gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp22_ = self->content;
			_tmp23_ = g_strdup_printf ("`%s'", _tmp22_);
			result = _tmp23_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_EOF:
		{
			gchar* _tmp24_;
			_tmp24_ = g_strdup ("<EOF>");
			result = _tmp24_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static void
valadoc_gtkdoc_value_token_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
valadoc_gtkdoc_value_token_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		valadoc_gtkdoc_token_unref (value->data[0].v_pointer);
	}
}


static void
valadoc_gtkdoc_value_token_copy_value (const GValue* src_value,
                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = valadoc_gtkdoc_token_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
valadoc_gtkdoc_value_token_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
valadoc_gtkdoc_value_token_collect_value (GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValadocGtkdocToken * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = valadoc_gtkdoc_token_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
valadoc_gtkdoc_value_token_lcopy_value (const GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	ValadocGtkdocToken ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = valadoc_gtkdoc_token_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec*
valadoc_gtkdoc_param_spec_token (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags)
{
	ValadocGtkdocParamSpecToken* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALADOC_GTKDOC_TYPE_TOKEN), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer
valadoc_gtkdoc_value_get_token (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALADOC_GTKDOC_TYPE_TOKEN), NULL);
	return value->data[0].v_pointer;
}


void
valadoc_gtkdoc_value_set_token (GValue* value,
                                gpointer v_object)
{
	ValadocGtkdocToken * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALADOC_GTKDOC_TYPE_TOKEN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALADOC_GTKDOC_TYPE_TOKEN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		valadoc_gtkdoc_token_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		valadoc_gtkdoc_token_unref (old);
	}
}


void
valadoc_gtkdoc_value_take_token (GValue* value,
                                 gpointer v_object)
{
	ValadocGtkdocToken * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALADOC_GTKDOC_TYPE_TOKEN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALADOC_GTKDOC_TYPE_TOKEN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		valadoc_gtkdoc_token_unref (old);
	}
}


static void
valadoc_gtkdoc_token_class_init (ValadocGtkdocTokenClass * klass)
{
	valadoc_gtkdoc_token_parent_class = g_type_class_peek_parent (klass);
	((ValadocGtkdocTokenClass *) klass)->finalize = valadoc_gtkdoc_token_finalize;
}


static void
valadoc_gtkdoc_token_instance_init (ValadocGtkdocToken * self)
{
	self->ref_count = 1;
}


static void
valadoc_gtkdoc_token_finalize (ValadocGtkdocToken * obj)
{
	ValadocGtkdocToken * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_GTKDOC_TYPE_TOKEN, ValadocGtkdocToken);
	g_signal_handlers_destroy (self);
	_g_free0 (self->content);
	_vala_map_unref0 (self->attributes);
}


GType
valadoc_gtkdoc_token_get_type (void)
{
	static volatile gsize valadoc_gtkdoc_token_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_gtkdoc_token_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { valadoc_gtkdoc_value_token_init, valadoc_gtkdoc_value_token_free_value, valadoc_gtkdoc_value_token_copy_value, valadoc_gtkdoc_value_token_peek_pointer, "p", valadoc_gtkdoc_value_token_collect_value, "p", valadoc_gtkdoc_value_token_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValadocGtkdocTokenClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_gtkdoc_token_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocGtkdocToken), 0, (GInstanceInitFunc) valadoc_gtkdoc_token_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType valadoc_gtkdoc_token_type_id;
		valadoc_gtkdoc_token_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValadocGtkdocToken", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&valadoc_gtkdoc_token_type_id__volatile, valadoc_gtkdoc_token_type_id);
	}
	return valadoc_gtkdoc_token_type_id__volatile;
}


gpointer
valadoc_gtkdoc_token_ref (gpointer instance)
{
	ValadocGtkdocToken * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void
valadoc_gtkdoc_token_unref (gpointer instance)
{
	ValadocGtkdocToken * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALADOC_GTKDOC_TOKEN_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


ValadocGtkdocScanner*
valadoc_gtkdoc_scanner_construct (GType object_type)
{
	ValadocGtkdocScanner* self = NULL;
	self = (ValadocGtkdocScanner*) g_type_create_instance (object_type);
	return self;
}


ValadocGtkdocScanner*
valadoc_gtkdoc_scanner_new (void)
{
	return valadoc_gtkdoc_scanner_construct (VALADOC_GTKDOC_TYPE_SCANNER);
}


static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}


gchar*
valadoc_gtkdoc_scanner_unescape (const gchar* txt)
{
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_;
	const gchar* start = NULL;
	const gchar* pos = NULL;
	gunichar c = 0U;
	g_return_val_if_fail (txt != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	start = txt;
	{
		gboolean _tmp1_ = FALSE;
		pos = txt;
		_tmp1_ = TRUE;
		while (TRUE) {
			const gchar* _tmp4_;
			gunichar _tmp5_;
			gunichar _tmp6_;
			if (!_tmp1_) {
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				_tmp2_ = pos;
				_tmp3_ = g_utf8_next_char (_tmp2_);
				pos = _tmp3_;
			}
			_tmp1_ = FALSE;
			_tmp4_ = pos;
			c = string_get_char (_tmp4_, (glong) 0);
			_tmp5_ = c;
			if (!(_tmp5_ != ((gunichar) '\0'))) {
				break;
			}
			_tmp6_ = c;
			if (_tmp6_ == ((gunichar) '&')) {
				const gchar* _tmp7_;
				_tmp7_ = pos;
				if (g_str_has_prefix (_tmp7_, "&solidus;")) {
					GString* _tmp8_;
					const gchar* _tmp9_;
					const gchar* _tmp10_;
					const gchar* _tmp11_;
					const gchar* _tmp12_;
					const gchar* _tmp13_;
					GString* _tmp14_;
					_tmp8_ = builder;
					_tmp9_ = start;
					_tmp10_ = pos;
					_tmp11_ = start;
					g_string_append_len (_tmp8_, _tmp9_, (gssize) (((gchar*) _tmp10_) - ((gchar*) _tmp11_)));
					_tmp12_ = pos;
					start = (const gchar*) (((gchar*) _tmp12_) + 9);
					_tmp13_ = pos;
					pos = (const gchar*) (((gchar*) _tmp13_) + 8);
					_tmp14_ = builder;
					g_string_append_unichar (_tmp14_, 8260U);
				} else {
					const gchar* _tmp15_;
					_tmp15_ = pos;
					if (g_str_has_prefix (_tmp15_, "&percnt;")) {
						GString* _tmp16_;
						const gchar* _tmp17_;
						const gchar* _tmp18_;
						const gchar* _tmp19_;
						const gchar* _tmp20_;
						const gchar* _tmp21_;
						GString* _tmp22_;
						_tmp16_ = builder;
						_tmp17_ = start;
						_tmp18_ = pos;
						_tmp19_ = start;
						g_string_append_len (_tmp16_, _tmp17_, (gssize) (((gchar*) _tmp18_) - ((gchar*) _tmp19_)));
						_tmp20_ = pos;
						start = (const gchar*) (((gchar*) _tmp20_) + 8);
						_tmp21_ = pos;
						pos = (const gchar*) (((gchar*) _tmp21_) + 7);
						_tmp22_ = builder;
						g_string_append_c (_tmp22_, '%');
					} else {
						const gchar* _tmp23_;
						_tmp23_ = pos;
						if (g_str_has_prefix (_tmp23_, "&commat;")) {
							GString* _tmp24_;
							const gchar* _tmp25_;
							const gchar* _tmp26_;
							const gchar* _tmp27_;
							const gchar* _tmp28_;
							const gchar* _tmp29_;
							GString* _tmp30_;
							_tmp24_ = builder;
							_tmp25_ = start;
							_tmp26_ = pos;
							_tmp27_ = start;
							g_string_append_len (_tmp24_, _tmp25_, (gssize) (((gchar*) _tmp26_) - ((gchar*) _tmp27_)));
							_tmp28_ = pos;
							start = (const gchar*) (((gchar*) _tmp28_) + 8);
							_tmp29_ = pos;
							pos = (const gchar*) (((gchar*) _tmp29_) + 7);
							_tmp30_ = builder;
							g_string_append_c (_tmp30_, '@');
						} else {
							const gchar* _tmp31_;
							_tmp31_ = pos;
							if (g_str_has_prefix (_tmp31_, "&nbsp;")) {
								GString* _tmp32_;
								const gchar* _tmp33_;
								const gchar* _tmp34_;
								const gchar* _tmp35_;
								const gchar* _tmp36_;
								const gchar* _tmp37_;
								GString* _tmp38_;
								_tmp32_ = builder;
								_tmp33_ = start;
								_tmp34_ = pos;
								_tmp35_ = start;
								g_string_append_len (_tmp32_, _tmp33_, (gssize) (((gchar*) _tmp34_) - ((gchar*) _tmp35_)));
								_tmp36_ = pos;
								start = (const gchar*) (((gchar*) _tmp36_) + 6);
								_tmp37_ = pos;
								pos = (const gchar*) (((gchar*) _tmp37_) + 5);
								_tmp38_ = builder;
								g_string_append_c (_tmp38_, ' ');
							} else {
								const gchar* _tmp39_;
								_tmp39_ = pos;
								if (g_str_has_prefix (_tmp39_, "&quot;")) {
									GString* _tmp40_;
									const gchar* _tmp41_;
									const gchar* _tmp42_;
									const gchar* _tmp43_;
									const gchar* _tmp44_;
									const gchar* _tmp45_;
									GString* _tmp46_;
									_tmp40_ = builder;
									_tmp41_ = start;
									_tmp42_ = pos;
									_tmp43_ = start;
									g_string_append_len (_tmp40_, _tmp41_, (gssize) (((gchar*) _tmp42_) - ((gchar*) _tmp43_)));
									_tmp44_ = pos;
									start = (const gchar*) (((gchar*) _tmp44_) + 6);
									_tmp45_ = pos;
									pos = (const gchar*) (((gchar*) _tmp45_) + 5);
									_tmp46_ = builder;
									g_string_append_c (_tmp46_, '"');
								} else {
									const gchar* _tmp47_;
									_tmp47_ = pos;
									if (g_str_has_prefix (_tmp47_, "&apos;")) {
										GString* _tmp48_;
										const gchar* _tmp49_;
										const gchar* _tmp50_;
										const gchar* _tmp51_;
										const gchar* _tmp52_;
										const gchar* _tmp53_;
										GString* _tmp54_;
										_tmp48_ = builder;
										_tmp49_ = start;
										_tmp50_ = pos;
										_tmp51_ = start;
										g_string_append_len (_tmp48_, _tmp49_, (gssize) (((gchar*) _tmp50_) - ((gchar*) _tmp51_)));
										_tmp52_ = pos;
										start = (const gchar*) (((gchar*) _tmp52_) + 6);
										_tmp53_ = pos;
										pos = (const gchar*) (((gchar*) _tmp53_) + 5);
										_tmp54_ = builder;
										g_string_append_c (_tmp54_, '\'');
									} else {
										const gchar* _tmp55_;
										_tmp55_ = pos;
										if (g_str_has_prefix (_tmp55_, "&lpar;")) {
											GString* _tmp56_;
											const gchar* _tmp57_;
											const gchar* _tmp58_;
											const gchar* _tmp59_;
											const gchar* _tmp60_;
											const gchar* _tmp61_;
											GString* _tmp62_;
											_tmp56_ = builder;
											_tmp57_ = start;
											_tmp58_ = pos;
											_tmp59_ = start;
											g_string_append_len (_tmp56_, _tmp57_, (gssize) (((gchar*) _tmp58_) - ((gchar*) _tmp59_)));
											_tmp60_ = pos;
											start = (const gchar*) (((gchar*) _tmp60_) + 6);
											_tmp61_ = pos;
											pos = (const gchar*) (((gchar*) _tmp61_) + 5);
											_tmp62_ = builder;
											g_string_append_c (_tmp62_, '(');
										} else {
											const gchar* _tmp63_;
											_tmp63_ = pos;
											if (g_str_has_prefix (_tmp63_, "&rpar;")) {
												GString* _tmp64_;
												const gchar* _tmp65_;
												const gchar* _tmp66_;
												const gchar* _tmp67_;
												const gchar* _tmp68_;
												const gchar* _tmp69_;
												GString* _tmp70_;
												_tmp64_ = builder;
												_tmp65_ = start;
												_tmp66_ = pos;
												_tmp67_ = start;
												g_string_append_len (_tmp64_, _tmp65_, (gssize) (((gchar*) _tmp66_) - ((gchar*) _tmp67_)));
												_tmp68_ = pos;
												start = (const gchar*) (((gchar*) _tmp68_) + 6);
												_tmp69_ = pos;
												pos = (const gchar*) (((gchar*) _tmp69_) + 5);
												_tmp70_ = builder;
												g_string_append_c (_tmp70_, ')');
											} else {
												const gchar* _tmp71_;
												_tmp71_ = pos;
												if (g_str_has_prefix (_tmp71_, "&num;")) {
													GString* _tmp72_;
													const gchar* _tmp73_;
													const gchar* _tmp74_;
													const gchar* _tmp75_;
													const gchar* _tmp76_;
													const gchar* _tmp77_;
													GString* _tmp78_;
													_tmp72_ = builder;
													_tmp73_ = start;
													_tmp74_ = pos;
													_tmp75_ = start;
													g_string_append_len (_tmp72_, _tmp73_, (gssize) (((gchar*) _tmp74_) - ((gchar*) _tmp75_)));
													_tmp76_ = pos;
													start = (const gchar*) (((gchar*) _tmp76_) + 5);
													_tmp77_ = pos;
													pos = (const gchar*) (((gchar*) _tmp77_) + 4);
													_tmp78_ = builder;
													g_string_append_c (_tmp78_, '#');
												} else {
													const gchar* _tmp79_;
													_tmp79_ = pos;
													if (g_str_has_prefix (_tmp79_, "&amp;")) {
														GString* _tmp80_;
														const gchar* _tmp81_;
														const gchar* _tmp82_;
														const gchar* _tmp83_;
														const gchar* _tmp84_;
														const gchar* _tmp85_;
														GString* _tmp86_;
														_tmp80_ = builder;
														_tmp81_ = start;
														_tmp82_ = pos;
														_tmp83_ = start;
														g_string_append_len (_tmp80_, _tmp81_, (gssize) (((gchar*) _tmp82_) - ((gchar*) _tmp83_)));
														_tmp84_ = pos;
														start = (const gchar*) (((gchar*) _tmp84_) + 5);
														_tmp85_ = pos;
														pos = (const gchar*) (((gchar*) _tmp85_) + 4);
														_tmp86_ = builder;
														g_string_append_c (_tmp86_, '&');
													} else {
														const gchar* _tmp87_;
														_tmp87_ = pos;
														if (g_str_has_prefix (_tmp87_, "&ast;")) {
															GString* _tmp88_;
															const gchar* _tmp89_;
															const gchar* _tmp90_;
															const gchar* _tmp91_;
															const gchar* _tmp92_;
															const gchar* _tmp93_;
															GString* _tmp94_;
															_tmp88_ = builder;
															_tmp89_ = start;
															_tmp90_ = pos;
															_tmp91_ = start;
															g_string_append_len (_tmp88_, _tmp89_, (gssize) (((gchar*) _tmp90_) - ((gchar*) _tmp91_)));
															_tmp92_ = pos;
															start = (const gchar*) (((gchar*) _tmp92_) + 5);
															_tmp93_ = pos;
															pos = (const gchar*) (((gchar*) _tmp93_) + 4);
															_tmp94_ = builder;
															g_string_append_c (_tmp94_, '*');
														} else {
															const gchar* _tmp95_;
															_tmp95_ = pos;
															if (g_str_has_prefix (_tmp95_, "&pi;")) {
																GString* _tmp96_;
																const gchar* _tmp97_;
																const gchar* _tmp98_;
																const gchar* _tmp99_;
																const gchar* _tmp100_;
																const gchar* _tmp101_;
																GString* _tmp102_;
																_tmp96_ = builder;
																_tmp97_ = start;
																_tmp98_ = pos;
																_tmp99_ = start;
																g_string_append_len (_tmp96_, _tmp97_, (gssize) (((gchar*) _tmp98_) - ((gchar*) _tmp99_)));
																_tmp100_ = pos;
																start = (const gchar*) (((gchar*) _tmp100_) + 4);
																_tmp101_ = pos;
																pos = (const gchar*) (((gchar*) _tmp101_) + 3);
																_tmp102_ = builder;
																g_string_append_unichar (_tmp102_, 960U);
															} else {
																const gchar* _tmp103_;
																_tmp103_ = pos;
																if (g_str_has_prefix (_tmp103_, "&lt;")) {
																	GString* _tmp104_;
																	const gchar* _tmp105_;
																	const gchar* _tmp106_;
																	const gchar* _tmp107_;
																	const gchar* _tmp108_;
																	const gchar* _tmp109_;
																	GString* _tmp110_;
																	_tmp104_ = builder;
																	_tmp105_ = start;
																	_tmp106_ = pos;
																	_tmp107_ = start;
																	g_string_append_len (_tmp104_, _tmp105_, (gssize) (((gchar*) _tmp106_) - ((gchar*) _tmp107_)));
																	_tmp108_ = pos;
																	start = (const gchar*) (((gchar*) _tmp108_) + 4);
																	_tmp109_ = pos;
																	pos = (const gchar*) (((gchar*) _tmp109_) + 3);
																	_tmp110_ = builder;
																	g_string_append_c (_tmp110_, '<');
																} else {
																	const gchar* _tmp111_;
																	_tmp111_ = pos;
																	if (g_str_has_prefix (_tmp111_, "&gt;")) {
																		GString* _tmp112_;
																		const gchar* _tmp113_;
																		const gchar* _tmp114_;
																		const gchar* _tmp115_;
																		const gchar* _tmp116_;
																		const gchar* _tmp117_;
																		GString* _tmp118_;
																		_tmp112_ = builder;
																		_tmp113_ = start;
																		_tmp114_ = pos;
																		_tmp115_ = start;
																		g_string_append_len (_tmp112_, _tmp113_, (gssize) (((gchar*) _tmp114_) - ((gchar*) _tmp115_)));
																		_tmp116_ = pos;
																		start = (const gchar*) (((gchar*) _tmp116_) + 4);
																		_tmp117_ = pos;
																		pos = (const gchar*) (((gchar*) _tmp117_) + 3);
																		_tmp118_ = builder;
																		g_string_append_c (_tmp118_, '>');
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	if ((&txt) == (&start)) {
		gchar* _tmp119_;
		_tmp119_ = g_strdup (txt);
		result = _tmp119_;
		_g_string_free0 (builder);
		return result;
	} else {
		GString* _tmp120_;
		const gchar* _tmp121_;
		const gchar* _tmp122_;
		const gchar* _tmp123_;
		GString* _tmp124_;
		gchar* _tmp125_;
		_tmp120_ = builder;
		_tmp121_ = start;
		_tmp122_ = pos;
		_tmp123_ = start;
		g_string_append_len (_tmp120_, _tmp121_, (gssize) (((gchar*) _tmp122_) - ((gchar*) _tmp123_)));
		_tmp124_ = builder;
		_tmp125_ = _tmp124_->str;
		_tmp124_->str = NULL;
		result = _tmp125_;
		_g_string_free0 (builder);
		return result;
	}
	_g_string_free0 (builder);
}


void
valadoc_gtkdoc_scanner_reset (ValadocGtkdocScanner* self,
                              const gchar* content)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (content != NULL);
	self->priv->content = content;
	_valadoc_gtkdoc_token_unref0 (self->priv->tmp_token);
	self->priv->tmp_token = NULL;
	self->priv->pos = content;
	self->priv->column = 0;
	self->priv->line = 0;
}


static inline gunichar
valadoc_gtkdoc_scanner_next_char (ValadocGtkdocScanner* self)
{
	gunichar result = 0U;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	const gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->pos;
	_tmp1_ = g_utf8_next_char (_tmp0_);
	self->priv->pos = _tmp1_;
	_tmp2_ = self->priv->column;
	self->priv->column = _tmp2_ + 1;
	_tmp3_ = self->priv->pos;
	result = string_get_char (_tmp3_, (glong) 0);
	return result;
}


static inline gunichar
valadoc_gtkdoc_scanner_get (ValadocGtkdocScanner* self)
{
	gunichar result = 0U;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->pos;
	result = string_get_char (_tmp0_, (glong) 0);
	return result;
}


static inline gboolean
valadoc_gtkdoc_scanner_letter (ValadocGtkdocScanner* self,
                               gunichar c)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (c >= ((gunichar) 'a')) {
		_tmp1_ = c <= ((gunichar) 'z');
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if (c >= ((gunichar) 'A')) {
			_tmp2_ = c <= ((gunichar) 'Z');
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	result = _tmp0_;
	return result;
}


static inline gboolean
valadoc_gtkdoc_scanner_letter_or_number (ValadocGtkdocScanner* self,
                                         gunichar c)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (c >= ((gunichar) 'a')) {
		_tmp2_ = c <= ((gunichar) 'z');
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		if (c >= ((gunichar) 'A')) {
			_tmp3_ = c <= ((gunichar) 'Z');
		} else {
			_tmp3_ = FALSE;
		}
		_tmp1_ = _tmp3_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp4_ = FALSE;
		if (c >= ((gunichar) '0')) {
			_tmp4_ = c <= ((gunichar) '9');
		} else {
			_tmp4_ = FALSE;
		}
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}


static inline gboolean
valadoc_gtkdoc_scanner_space (ValadocGtkdocScanner* self,
                              gunichar c)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (c == ((gunichar) ' ')) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = c == ((gunichar) '\t');
	}
	result = _tmp0_;
	return result;
}


static inline gboolean
valadoc_gtkdoc_scanner_space_or_newline (ValadocGtkdocScanner* self,
                                         gunichar c)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (c == ((gunichar) '\n')) {
		gint _tmp0_;
		_tmp0_ = self->priv->line;
		self->priv->line = _tmp0_ + 1;
		self->priv->column = 0;
		result = TRUE;
		return result;
	}
	result = valadoc_gtkdoc_scanner_space (self, c);
	return result;
}


static inline gint
valadoc_gtkdoc_scanner_offset (ValadocGtkdocScanner* self,
                               const gchar* a,
                               const gchar* b)
{
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	result = (gint) (((gchar*) a) - ((gchar*) b));
	return result;
}


static inline gint
valadoc_gtkdoc_scanner_vararg_prefix (ValadocGtkdocScanner* self)
{
	gint result = 0;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->pos;
	if (g_str_has_prefix (_tmp0_, "...")) {
		valadoc_gtkdoc_scanner_next_char (self);
		valadoc_gtkdoc_scanner_next_char (self);
		valadoc_gtkdoc_scanner_next_char (self);
		result = 3;
		return result;
	}
	result = 0;
	return result;
}


static inline gint
valadoc_gtkdoc_scanner_id_prefix (ValadocGtkdocScanner* self)
{
	gint result = 0;
	gunichar c = 0U;
	gboolean _tmp0_ = FALSE;
	gunichar _tmp1_;
	gint start = 0;
	gint _tmp3_;
	gint _tmp7_;
	gint _tmp8_;
	g_return_val_if_fail (self != NULL, 0);
	c = valadoc_gtkdoc_scanner_get (self);
	_tmp1_ = c;
	if (!valadoc_gtkdoc_scanner_letter (self, _tmp1_)) {
		gunichar _tmp2_;
		_tmp2_ = c;
		_tmp0_ = _tmp2_ != ((gunichar) '_');
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	}
	_tmp3_ = self->priv->column;
	start = _tmp3_;
	while (TRUE) {
		gboolean _tmp4_ = FALSE;
		gunichar _tmp5_;
		c = valadoc_gtkdoc_scanner_next_char (self);
		_tmp5_ = c;
		if (_tmp5_ == ((gunichar) '_')) {
			_tmp4_ = TRUE;
		} else {
			gunichar _tmp6_;
			_tmp6_ = c;
			_tmp4_ = valadoc_gtkdoc_scanner_letter_or_number (self, _tmp6_);
		}
		if (!_tmp4_) {
			break;
		}
	}
	_tmp7_ = self->priv->column;
	_tmp8_ = start;
	result = _tmp7_ - _tmp8_;
	return result;
}


static inline gint
valadoc_gtkdoc_scanner_g_id_prefix (ValadocGtkdocScanner* self)
{
	gint result = 0;
	const gchar* start = NULL;
	const gchar* _tmp0_;
	gunichar c = 0U;
	gunichar _tmp1_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	c = valadoc_gtkdoc_scanner_get (self);
	_tmp1_ = c;
	if (!valadoc_gtkdoc_scanner_letter (self, _tmp1_)) {
		result = 0;
		return result;
	}
	while (TRUE) {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		gunichar _tmp4_;
		c = valadoc_gtkdoc_scanner_next_char (self);
		_tmp4_ = c;
		if (_tmp4_ == ((gunichar) '_')) {
			_tmp3_ = TRUE;
		} else {
			gunichar _tmp5_;
			_tmp5_ = c;
			_tmp3_ = _tmp5_ == ((gunichar) '-');
		}
		if (_tmp3_) {
			_tmp2_ = TRUE;
		} else {
			gunichar _tmp6_;
			_tmp6_ = c;
			_tmp2_ = valadoc_gtkdoc_scanner_letter_or_number (self, _tmp6_);
		}
		if (!_tmp2_) {
			break;
		}
	}
	_tmp7_ = self->priv->pos;
	_tmp8_ = start;
	result = valadoc_gtkdoc_scanner_offset (self, _tmp7_, _tmp8_);
	return result;
}


static inline gint
valadoc_gtkdoc_scanner_skip_spaces_and_newlines (ValadocGtkdocScanner* self)
{
	gint result = 0;
	const gchar* start = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	if (valadoc_gtkdoc_scanner_space_or_newline (self, valadoc_gtkdoc_scanner_get (self))) {
		while (TRUE) {
			if (!valadoc_gtkdoc_scanner_space_or_newline (self, valadoc_gtkdoc_scanner_next_char (self))) {
				break;
			}
		}
	}
	_tmp1_ = self->priv->pos;
	_tmp2_ = start;
	result = valadoc_gtkdoc_scanner_offset (self, _tmp1_, _tmp2_);
	return result;
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static inline ValadocGtkdocToken*
valadoc_gtkdoc_scanner_function_prefix (ValadocGtkdocScanner* self)
{
	ValadocGtkdocToken* result = NULL;
	const gchar* start = NULL;
	const gchar* _tmp0_;
	gint column_start = 0;
	gint _tmp1_;
	gint id_len = 0;
	gint _tmp2_;
	ValadocGtkdocToken* _tmp3_;
	ValadocGtkdocToken* _tmp4_;
	ValadocGtkdocToken* _tmp7_;
	ValadocGtkdocToken* _tmp8_;
	const gchar* _tmp11_;
	gint _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	ValadocGtkdocToken* _tmp21_;
	ValadocGtkdocToken* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	_tmp1_ = self->priv->column;
	column_start = _tmp1_;
	id_len = 0;
	id_len = valadoc_gtkdoc_scanner_id_prefix (self);
	_tmp2_ = id_len;
	if (_tmp2_ == 0) {
		result = NULL;
		return result;
	}
	_tmp3_ = valadoc_gtkdoc_scanner_space_prefix (self);
	_tmp4_ = _tmp3_;
	_valadoc_gtkdoc_token_unref0 (_tmp4_);
	if (valadoc_gtkdoc_scanner_get (self) != ((gunichar) '(')) {
		gint _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = column_start;
		self->priv->column = _tmp5_;
		_tmp6_ = start;
		self->priv->pos = _tmp6_;
		result = NULL;
		return result;
	}
	valadoc_gtkdoc_scanner_next_char (self);
	_tmp7_ = valadoc_gtkdoc_scanner_space_prefix (self);
	_tmp8_ = _tmp7_;
	_valadoc_gtkdoc_token_unref0 (_tmp8_);
	if (valadoc_gtkdoc_scanner_get (self) != ((gunichar) ')')) {
		gint _tmp9_;
		const gchar* _tmp10_;
		_tmp9_ = column_start;
		self->priv->column = _tmp9_;
		_tmp10_ = start;
		self->priv->pos = _tmp10_;
		result = NULL;
		return result;
	}
	valadoc_gtkdoc_scanner_next_char (self);
	_tmp11_ = start;
	_tmp12_ = id_len;
	_tmp13_ = string_substring (_tmp11_, (glong) 0, (glong) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = start;
	_tmp16_ = self->priv->pos;
	_tmp17_ = start;
	_tmp18_ = self->priv->line;
	_tmp19_ = column_start;
	_tmp20_ = self->priv->column;
	_tmp21_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_FUNCTION, _tmp14_, NULL, _tmp15_, valadoc_gtkdoc_scanner_offset (self, _tmp16_, _tmp17_), _tmp18_, _tmp19_, _tmp20_);
	_tmp22_ = _tmp21_;
	_g_free0 (_tmp14_);
	result = _tmp22_;
	return result;
}


static inline ValadocGtkdocToken*
valadoc_gtkdoc_scanner_gtkdoc_symbolic_link_prefix (ValadocGtkdocScanner* self,
                                                    gunichar c,
                                                    ValadocGtkdocTokenType type)
{
	ValadocGtkdocToken* result = NULL;
	const gchar* start = NULL;
	const gchar* _tmp0_;
	gint column_start = 0;
	gint _tmp1_;
	gint id_len = 0;
	gint _tmp2_;
	const gchar* separator = NULL;
	const gchar* _tmp7_;
	const gchar* _tmp34_;
	gint _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	ValadocGtkdocToken* _tmp44_;
	ValadocGtkdocToken* _tmp45_;
	g_return_val_if_fail (self != NULL, NULL);
	if (valadoc_gtkdoc_scanner_get (self) != c) {
		result = NULL;
		return result;
	}
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	_tmp1_ = self->priv->column;
	column_start = _tmp1_;
	valadoc_gtkdoc_scanner_next_char (self);
	id_len = 0;
	id_len = valadoc_gtkdoc_scanner_id_prefix (self);
	_tmp2_ = id_len;
	if (_tmp2_ == 0) {
		gboolean _tmp3_ = FALSE;
		if (type == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAM) {
			gint _tmp4_;
			id_len = valadoc_gtkdoc_scanner_vararg_prefix (self);
			_tmp4_ = id_len;
			_tmp3_ = _tmp4_ == 0;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			gint _tmp5_;
			const gchar* _tmp6_;
			_tmp5_ = column_start;
			self->priv->column = _tmp5_;
			_tmp6_ = start;
			self->priv->pos = _tmp6_;
			result = NULL;
			return result;
		}
	}
	_tmp7_ = self->priv->pos;
	separator = _tmp7_;
	if (valadoc_gtkdoc_scanner_get (self) == ((gunichar) ':')) {
		gint separator_len = 0;
		gint id_len2 = 0;
		gint _tmp9_;
		separator_len = 1;
		if (valadoc_gtkdoc_scanner_next_char (self) == ((gunichar) ':')) {
			gint _tmp8_;
			valadoc_gtkdoc_scanner_next_char (self);
			_tmp8_ = separator_len;
			separator_len = _tmp8_ + 1;
		}
		id_len2 = valadoc_gtkdoc_scanner_g_id_prefix (self);
		_tmp9_ = id_len2;
		if (_tmp9_ == 0) {
			const gchar* _tmp10_;
			_tmp10_ = separator;
			self->priv->pos = _tmp10_;
		} else {
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			_tmp11_ = id_len;
			_tmp12_ = id_len2;
			_tmp13_ = separator_len;
			id_len = _tmp11_ + (_tmp12_ + _tmp13_);
		}
	} else {
		gboolean _tmp14_ = FALSE;
		const gchar* _tmp15_;
		_tmp15_ = self->priv->pos;
		if (g_str_has_prefix (_tmp15_, "->")) {
			_tmp14_ = TRUE;
		} else {
			const gchar* _tmp16_;
			_tmp16_ = self->priv->pos;
			_tmp14_ = g_str_has_prefix (_tmp16_, ".");
		}
		if (_tmp14_) {
			const gchar* sep_start = NULL;
			const gchar* _tmp17_;
			gint sep_column_start = 0;
			gint _tmp18_;
			gint separator_len = 0;
			const gchar* _tmp19_;
			ValadocGtkdocToken* func_token = NULL;
			ValadocGtkdocToken* _tmp20_;
			ValadocGtkdocToken* _tmp21_;
			_tmp17_ = self->priv->pos;
			sep_start = _tmp17_;
			_tmp18_ = self->priv->column;
			sep_column_start = _tmp18_;
			separator_len = 1;
			_tmp19_ = self->priv->pos;
			if (g_str_has_prefix (_tmp19_, "->")) {
				separator_len = 2;
				valadoc_gtkdoc_scanner_next_char (self);
			}
			valadoc_gtkdoc_scanner_next_char (self);
			_tmp20_ = valadoc_gtkdoc_scanner_function_prefix (self);
			func_token = _tmp20_;
			_tmp21_ = func_token;
			if (_tmp21_ == NULL) {
				gint id_len2 = 0;
				gint _tmp22_;
				id_len2 = valadoc_gtkdoc_scanner_id_prefix (self);
				_tmp22_ = id_len2;
				if (_tmp22_ > 0) {
					gint _tmp23_;
					gint _tmp24_;
					gint _tmp25_;
					_tmp23_ = id_len;
					_tmp24_ = separator_len;
					_tmp25_ = id_len2;
					id_len = _tmp23_ + (_tmp24_ + _tmp25_);
				} else {
					gint _tmp26_;
					const gchar* _tmp27_;
					_tmp26_ = sep_column_start;
					self->priv->column = _tmp26_;
					_tmp27_ = sep_start;
					self->priv->pos = _tmp27_;
				}
			} else {
				gint _tmp28_;
				gint _tmp29_;
				ValadocGtkdocToken* _tmp30_;
				const gchar* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				_tmp28_ = id_len;
				_tmp29_ = separator_len;
				_tmp30_ = func_token;
				_tmp31_ = _tmp30_->content;
				_tmp32_ = strlen (_tmp31_);
				_tmp33_ = _tmp32_;
				id_len = _tmp28_ + (_tmp29_ + _tmp33_);
			}
			_valadoc_gtkdoc_token_unref0 (func_token);
		}
	}
	_tmp34_ = start;
	_tmp35_ = id_len;
	_tmp36_ = string_substring (_tmp34_, (glong) 1, (glong) _tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = start;
	_tmp39_ = self->priv->pos;
	_tmp40_ = start;
	_tmp41_ = self->priv->line;
	_tmp42_ = column_start;
	_tmp43_ = self->priv->column;
	_tmp44_ = valadoc_gtkdoc_token_new (type, _tmp37_, NULL, _tmp38_, valadoc_gtkdoc_scanner_offset (self, _tmp39_, _tmp40_), _tmp41_, _tmp42_, _tmp43_);
	_tmp45_ = _tmp44_;
	_g_free0 (_tmp37_);
	result = _tmp45_;
	return result;
}


static inline ValadocGtkdocToken*
valadoc_gtkdoc_scanner_gtkdoc_property_prefix (ValadocGtkdocScanner* self)
{
	ValadocGtkdocToken* result = NULL;
	const gchar* start = NULL;
	const gchar* _tmp0_;
	gint column_start = 0;
	gint _tmp1_;
	gint id_len = 0;
	gint _tmp2_;
	const gchar* _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	ValadocGtkdocToken* _tmp15_;
	ValadocGtkdocToken* _tmp16_;
	g_return_val_if_fail (self != NULL, NULL);
	if (valadoc_gtkdoc_scanner_get (self) != ((gunichar) ':')) {
		result = NULL;
		return result;
	}
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	_tmp1_ = self->priv->column;
	column_start = _tmp1_;
	valadoc_gtkdoc_scanner_next_char (self);
	id_len = 0;
	id_len = valadoc_gtkdoc_scanner_g_id_prefix (self);
	_tmp2_ = id_len;
	if (_tmp2_ == 0) {
		gint _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = column_start;
		self->priv->column = _tmp3_;
		_tmp4_ = start;
		self->priv->pos = _tmp4_;
		result = NULL;
		return result;
	}
	_tmp5_ = start;
	_tmp6_ = id_len;
	_tmp7_ = string_substring (_tmp5_, (glong) 1, (glong) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = start;
	_tmp10_ = self->priv->pos;
	_tmp11_ = start;
	_tmp12_ = self->priv->line;
	_tmp13_ = column_start;
	_tmp14_ = self->priv->column;
	_tmp15_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PROPERTY, _tmp8_, NULL, _tmp9_, valadoc_gtkdoc_scanner_offset (self, _tmp10_, _tmp11_), _tmp12_, _tmp13_, _tmp14_);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp8_);
	result = _tmp16_;
	return result;
}


static inline ValadocGtkdocToken*
valadoc_gtkdoc_scanner_gtkdoc_signal_prefix (ValadocGtkdocScanner* self)
{
	ValadocGtkdocToken* result = NULL;
	const gchar* start = NULL;
	const gchar* _tmp0_;
	gint column_start = 0;
	gint _tmp1_;
	const gchar* _tmp4_;
	gint id_len = 0;
	gint _tmp5_;
	const gchar* _tmp8_;
	gint _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	ValadocGtkdocToken* _tmp18_;
	ValadocGtkdocToken* _tmp19_;
	g_return_val_if_fail (self != NULL, NULL);
	if (valadoc_gtkdoc_scanner_get (self) != ((gunichar) ':')) {
		result = NULL;
		return result;
	}
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	_tmp1_ = self->priv->column;
	column_start = _tmp1_;
	if (valadoc_gtkdoc_scanner_next_char (self) != ((gunichar) ':')) {
		gint _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = column_start;
		self->priv->column = _tmp2_;
		_tmp3_ = start;
		self->priv->pos = _tmp3_;
		result = NULL;
		return result;
	}
	_tmp4_ = self->priv->pos;
	start = _tmp4_;
	valadoc_gtkdoc_scanner_next_char (self);
	id_len = 0;
	id_len = valadoc_gtkdoc_scanner_g_id_prefix (self);
	_tmp5_ = id_len;
	if (_tmp5_ == 0) {
		gint _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = column_start;
		self->priv->column = _tmp6_;
		_tmp7_ = start;
		self->priv->pos = _tmp7_;
		result = NULL;
		return result;
	}
	_tmp8_ = start;
	_tmp9_ = id_len;
	_tmp10_ = string_substring (_tmp8_, (glong) 1, (glong) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = start;
	_tmp13_ = self->priv->pos;
	_tmp14_ = start;
	_tmp15_ = self->priv->line;
	_tmp16_ = column_start;
	_tmp17_ = self->priv->column;
	_tmp18_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SIGNAL, _tmp11_, NULL, _tmp12_, valadoc_gtkdoc_scanner_offset (self, _tmp13_, _tmp14_), _tmp15_, _tmp16_, _tmp17_);
	_tmp19_ = _tmp18_;
	_g_free0 (_tmp11_);
	result = _tmp19_;
	return result;
}


static inline ValadocGtkdocToken*
valadoc_gtkdoc_scanner_gtkdoc_const_prefix (ValadocGtkdocScanner* self)
{
	ValadocGtkdocToken* result = NULL;
	ValadocGtkdocToken* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_scanner_gtkdoc_symbolic_link_prefix (self, (gunichar) '%', VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_CONST);
	result = _tmp0_;
	return result;
}


static inline ValadocGtkdocToken*
valadoc_gtkdoc_scanner_gtkdoc_param_prefix (ValadocGtkdocScanner* self)
{
	ValadocGtkdocToken* result = NULL;
	ValadocGtkdocToken* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_scanner_gtkdoc_symbolic_link_prefix (self, (gunichar) '@', VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAM);
	result = _tmp0_;
	return result;
}


static inline ValadocGtkdocToken*
valadoc_gtkdoc_scanner_gtkdoc_type_prefix (ValadocGtkdocScanner* self)
{
	ValadocGtkdocToken* result = NULL;
	ValadocGtkdocToken* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_scanner_gtkdoc_symbolic_link_prefix (self, (gunichar) '#', VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_TYPE);
	result = _tmp0_;
	return result;
}


static inline ValadocGtkdocToken*
valadoc_gtkdoc_scanner_xml_prefix (ValadocGtkdocScanner* self)
{
	ValadocGtkdocToken* result = NULL;
	const gchar* start = NULL;
	const gchar* _tmp0_;
	gint line_start = 0;
	gint _tmp1_;
	gint column_start = 0;
	gint _tmp2_;
	gboolean close = FALSE;
	const gchar* id_start = NULL;
	const gchar* _tmp41_;
	gint id_len = 0;
	gint _tmp42_;
	ValaHashMap* map = NULL;
	GHashFunc _tmp45_;
	GEqualFunc _tmp46_;
	GEqualFunc _tmp47_;
	ValaHashMap* _tmp48_;
	gboolean open_and_close = FALSE;
	gboolean _tmp70_ = FALSE;
	gboolean _tmp71_;
	gboolean _tmp75_;
	gboolean _tmp87_;
	g_return_val_if_fail (self != NULL, NULL);
	if (valadoc_gtkdoc_scanner_get (self) != ((gunichar) '<')) {
		result = NULL;
		return result;
	}
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	_tmp1_ = self->priv->line;
	line_start = _tmp1_;
	_tmp2_ = self->priv->column;
	column_start = _tmp2_;
	valadoc_gtkdoc_scanner_next_char (self);
	if (valadoc_gtkdoc_scanner_get (self) == ((gunichar) '!')) {
		const gchar* _tmp38_;
		gint _tmp39_;
		gint _tmp40_;
		if (valadoc_gtkdoc_scanner_next_char (self) == ((gunichar) '-')) {
			if (valadoc_gtkdoc_scanner_next_char (self) != ((gunichar) '-')) {
				gint _tmp3_;
				const gchar* _tmp4_;
				_tmp3_ = column_start;
				self->priv->column = _tmp3_;
				_tmp4_ = start;
				self->priv->pos = _tmp4_;
				result = NULL;
				return result;
			}
			{
				gunichar c = 0U;
				c = valadoc_gtkdoc_scanner_next_char (self);
				{
					gboolean _tmp5_ = FALSE;
					_tmp5_ = TRUE;
					while (TRUE) {
						gunichar _tmp6_;
						gunichar _tmp7_;
						if (!_tmp5_) {
							c = valadoc_gtkdoc_scanner_next_char (self);
						}
						_tmp5_ = FALSE;
						_tmp6_ = c;
						if (!(_tmp6_ != ((gunichar) '\0'))) {
							break;
						}
						_tmp7_ = c;
						if (_tmp7_ == ((gunichar) '\n')) {
							gint _tmp8_;
							_tmp8_ = self->priv->line;
							self->priv->line = _tmp8_ + 1;
							self->priv->column = 0;
						} else {
							const gchar* _tmp9_;
							_tmp9_ = self->priv->pos;
							if (g_str_has_prefix (_tmp9_, "-->")) {
								const gchar* _tmp10_;
								const gchar* _tmp11_;
								const gchar* _tmp12_;
								gint _tmp13_;
								gint _tmp14_;
								gint _tmp15_;
								ValadocGtkdocToken* _tmp16_;
								valadoc_gtkdoc_scanner_next_char (self);
								valadoc_gtkdoc_scanner_next_char (self);
								valadoc_gtkdoc_scanner_next_char (self);
								_tmp10_ = start;
								_tmp11_ = self->priv->pos;
								_tmp12_ = start;
								_tmp13_ = self->priv->line;
								_tmp14_ = column_start;
								_tmp15_ = self->priv->column;
								_tmp16_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_XML_COMMENT, "", NULL, _tmp10_, valadoc_gtkdoc_scanner_offset (self, _tmp11_, _tmp12_), _tmp13_, _tmp14_, _tmp15_);
								result = _tmp16_;
								return result;
							}
						}
					}
				}
			}
		} else {
			const gchar* _tmp17_;
			_tmp17_ = self->priv->pos;
			if (g_str_has_prefix (_tmp17_, "[CDATA[")) {
				valadoc_gtkdoc_scanner_next_char (self);
				valadoc_gtkdoc_scanner_next_char (self);
				valadoc_gtkdoc_scanner_next_char (self);
				valadoc_gtkdoc_scanner_next_char (self);
				valadoc_gtkdoc_scanner_next_char (self);
				valadoc_gtkdoc_scanner_next_char (self);
				{
					gunichar c = 0U;
					c = valadoc_gtkdoc_scanner_next_char (self);
					{
						gboolean _tmp18_ = FALSE;
						_tmp18_ = TRUE;
						while (TRUE) {
							gunichar _tmp19_;
							gunichar _tmp20_;
							if (!_tmp18_) {
								c = valadoc_gtkdoc_scanner_next_char (self);
							}
							_tmp18_ = FALSE;
							_tmp19_ = c;
							if (!(_tmp19_ != ((gunichar) '\0'))) {
								break;
							}
							_tmp20_ = c;
							if (_tmp20_ == ((gunichar) '\n')) {
								gint _tmp21_;
								_tmp21_ = self->priv->line;
								self->priv->line = _tmp21_ + 1;
								self->priv->column = 0;
							} else {
								const gchar* _tmp22_;
								_tmp22_ = self->priv->pos;
								if (g_str_has_prefix (_tmp22_, "]]>")) {
									gchar* content = NULL;
									const gchar* _tmp23_;
									const gchar* _tmp24_;
									const gchar* _tmp25_;
									gchar* _tmp26_;
									const gchar* _tmp27_;
									gchar* _tmp28_;
									gchar* _tmp29_;
									const gchar* _tmp30_;
									const gchar* _tmp31_;
									const gchar* _tmp32_;
									gint _tmp33_;
									gint _tmp34_;
									gint _tmp35_;
									ValadocGtkdocToken* _tmp36_;
									ValadocGtkdocToken* _tmp37_;
									_tmp23_ = start;
									_tmp24_ = self->priv->pos;
									_tmp25_ = start;
									_tmp26_ = string_substring (_tmp23_, (glong) 9, (glong) (valadoc_gtkdoc_scanner_offset (self, _tmp24_, _tmp25_) - 9));
									content = _tmp26_;
									valadoc_gtkdoc_scanner_next_char (self);
									valadoc_gtkdoc_scanner_next_char (self);
									valadoc_gtkdoc_scanner_next_char (self);
									_tmp27_ = content;
									_tmp28_ = valadoc_gtkdoc_scanner_unescape (_tmp27_);
									_tmp29_ = _tmp28_;
									_tmp30_ = start;
									_tmp31_ = self->priv->pos;
									_tmp32_ = start;
									_tmp33_ = self->priv->line;
									_tmp34_ = column_start;
									_tmp35_ = self->priv->column;
									_tmp36_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_WORD, _tmp29_, NULL, _tmp30_, valadoc_gtkdoc_scanner_offset (self, _tmp31_, _tmp32_), _tmp33_, _tmp34_, _tmp35_);
									_tmp37_ = _tmp36_;
									_g_free0 (_tmp29_);
									result = _tmp37_;
									_g_free0 (content);
									return result;
								}
							}
						}
					}
				}
			}
		}
		_tmp38_ = start;
		self->priv->pos = _tmp38_;
		_tmp39_ = column_start;
		self->priv->column = _tmp39_;
		_tmp40_ = line_start;
		self->priv->line = _tmp40_;
		result = NULL;
		return result;
	}
	close = FALSE;
	if (valadoc_gtkdoc_scanner_get (self) == ((gunichar) '/')) {
		valadoc_gtkdoc_scanner_next_char (self);
		close = TRUE;
	}
	_tmp41_ = self->priv->pos;
	id_start = _tmp41_;
	id_len = 0;
	id_len = valadoc_gtkdoc_scanner_id_prefix (self);
	_tmp42_ = id_len;
	if (_tmp42_ == 0) {
		gint _tmp43_;
		const gchar* _tmp44_;
		_tmp43_ = column_start;
		self->priv->column = _tmp43_;
		_tmp44_ = start;
		self->priv->pos = _tmp44_;
		result = NULL;
		return result;
	}
	_tmp45_ = g_str_hash;
	_tmp46_ = g_str_equal;
	_tmp47_ = g_direct_equal;
	_tmp48_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp45_, _tmp46_, _tmp47_);
	map = _tmp48_;
	while (TRUE) {
		gboolean _tmp49_ = FALSE;
		gboolean _tmp50_;
		gchar* name = NULL;
		gchar* val = NULL;
		const gchar* att_pos = NULL;
		const gchar* _tmp51_;
		gint att_id_len = 0;
		gint _tmp52_;
		const gchar* _tmp53_;
		gint _tmp54_;
		gchar* _tmp55_;
		gunichar c = 0U;
		const gchar* _tmp56_;
		const gchar* _tmp63_;
		const gchar* _tmp64_;
		const gchar* _tmp65_;
		gchar* _tmp66_;
		ValaHashMap* _tmp67_;
		const gchar* _tmp68_;
		const gchar* _tmp69_;
		_tmp50_ = close;
		if (_tmp50_ == FALSE) {
			_tmp49_ = valadoc_gtkdoc_scanner_skip_spaces_and_newlines (self) > 0;
		} else {
			_tmp49_ = FALSE;
		}
		if (!_tmp49_) {
			break;
		}
		_tmp51_ = self->priv->pos;
		att_pos = _tmp51_;
		att_id_len = 0;
		att_id_len = valadoc_gtkdoc_scanner_id_prefix (self);
		_tmp52_ = att_id_len;
		if (_tmp52_ == 0) {
			_g_free0 (val);
			_g_free0 (name);
			break;
		}
		_tmp53_ = att_pos;
		_tmp54_ = att_id_len;
		_tmp55_ = string_substring (_tmp53_, (glong) 0, (glong) _tmp54_);
		_g_free0 (name);
		name = _tmp55_;
		if (valadoc_gtkdoc_scanner_get (self) != ((gunichar) '=')) {
			_g_free0 (val);
			_g_free0 (name);
			break;
		}
		valadoc_gtkdoc_scanner_next_char (self);
		valadoc_gtkdoc_scanner_skip_spaces_and_newlines (self);
		if (valadoc_gtkdoc_scanner_get (self) != ((gunichar) '"')) {
			_g_free0 (val);
			_g_free0 (name);
			break;
		}
		c = valadoc_gtkdoc_scanner_next_char (self);
		_tmp56_ = self->priv->pos;
		att_pos = _tmp56_;
		{
			gboolean _tmp57_ = FALSE;
			_tmp57_ = TRUE;
			while (TRUE) {
				gboolean _tmp58_ = FALSE;
				gboolean _tmp59_ = FALSE;
				gunichar _tmp60_;
				if (!_tmp57_) {
					c = valadoc_gtkdoc_scanner_next_char (self);
				}
				_tmp57_ = FALSE;
				_tmp60_ = c;
				if (_tmp60_ != ((gunichar) '\0')) {
					gunichar _tmp61_;
					_tmp61_ = c;
					_tmp59_ = _tmp61_ != ((gunichar) '\n');
				} else {
					_tmp59_ = FALSE;
				}
				if (_tmp59_) {
					gunichar _tmp62_;
					_tmp62_ = c;
					_tmp58_ = _tmp62_ != ((gunichar) '"');
				} else {
					_tmp58_ = FALSE;
				}
				if (!_tmp58_) {
					break;
				}
			}
		}
		_tmp63_ = att_pos;
		_tmp64_ = self->priv->pos;
		_tmp65_ = att_pos;
		_tmp66_ = string_substring (_tmp63_, (glong) 0, (glong) valadoc_gtkdoc_scanner_offset (self, _tmp64_, _tmp65_));
		_g_free0 (val);
		val = _tmp66_;
		if (valadoc_gtkdoc_scanner_get (self) != ((gunichar) '"')) {
			_g_free0 (val);
			_g_free0 (name);
			break;
		}
		valadoc_gtkdoc_scanner_next_char (self);
		_tmp67_ = map;
		_tmp68_ = name;
		_tmp69_ = val;
		vala_map_set ((ValaMap*) _tmp67_, _tmp68_, _tmp69_);
		_g_free0 (val);
		_g_free0 (name);
	}
	valadoc_gtkdoc_scanner_skip_spaces_and_newlines (self);
	open_and_close = FALSE;
	_tmp71_ = close;
	if (!_tmp71_) {
		_tmp70_ = valadoc_gtkdoc_scanner_get (self) == ((gunichar) '/');
	} else {
		_tmp70_ = FALSE;
	}
	if (_tmp70_) {
		open_and_close = TRUE;
		valadoc_gtkdoc_scanner_next_char (self);
	}
	if (valadoc_gtkdoc_scanner_get (self) != ((gunichar) '>')) {
		gint _tmp72_;
		gint _tmp73_;
		const gchar* _tmp74_;
		_tmp72_ = line_start;
		self->priv->line = _tmp72_;
		_tmp73_ = column_start;
		self->priv->column = _tmp73_;
		_tmp74_ = start;
		self->priv->pos = _tmp74_;
		result = NULL;
		_vala_map_unref0 (map);
		return result;
	}
	valadoc_gtkdoc_scanner_next_char (self);
	_tmp75_ = open_and_close;
	if (_tmp75_) {
		const gchar* _tmp76_;
		gint _tmp77_;
		gchar* _tmp78_;
		gchar* _tmp79_;
		const gchar* _tmp80_;
		const gchar* _tmp81_;
		const gchar* _tmp82_;
		gint _tmp83_;
		gint _tmp84_;
		gint _tmp85_;
		ValadocGtkdocToken* _tmp86_;
		_tmp76_ = id_start;
		_tmp77_ = id_len;
		_tmp78_ = string_substring (_tmp76_, (glong) 0, (glong) _tmp77_);
		_tmp79_ = _tmp78_;
		_tmp80_ = start;
		_tmp81_ = self->priv->pos;
		_tmp82_ = start;
		_tmp83_ = self->priv->line;
		_tmp84_ = column_start;
		_tmp85_ = self->priv->column;
		_tmp86_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE, _tmp79_, NULL, _tmp80_, valadoc_gtkdoc_scanner_offset (self, _tmp81_, _tmp82_), _tmp83_, _tmp84_, _tmp85_);
		_valadoc_gtkdoc_token_unref0 (self->priv->tmp_token);
		self->priv->tmp_token = _tmp86_;
		_g_free0 (_tmp79_);
	}
	_tmp87_ = close;
	if (_tmp87_) {
		const gchar* _tmp88_;
		gint _tmp89_;
		gchar* _tmp90_;
		gchar* _tmp91_;
		const gchar* _tmp92_;
		const gchar* _tmp93_;
		const gchar* _tmp94_;
		gint _tmp95_;
		gint _tmp96_;
		gint _tmp97_;
		ValadocGtkdocToken* _tmp98_;
		ValadocGtkdocToken* _tmp99_;
		_tmp88_ = id_start;
		_tmp89_ = id_len;
		_tmp90_ = string_substring (_tmp88_, (glong) 0, (glong) _tmp89_);
		_tmp91_ = _tmp90_;
		_tmp92_ = start;
		_tmp93_ = self->priv->pos;
		_tmp94_ = start;
		_tmp95_ = self->priv->line;
		_tmp96_ = column_start;
		_tmp97_ = self->priv->column;
		_tmp98_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE, _tmp91_, NULL, _tmp92_, valadoc_gtkdoc_scanner_offset (self, _tmp93_, _tmp94_), _tmp95_, _tmp96_, _tmp97_);
		_tmp99_ = _tmp98_;
		_g_free0 (_tmp91_);
		result = _tmp99_;
		_vala_map_unref0 (map);
		return result;
	} else {
		const gchar* _tmp100_;
		gint _tmp101_;
		gchar* _tmp102_;
		gchar* _tmp103_;
		ValaHashMap* _tmp104_;
		const gchar* _tmp105_;
		const gchar* _tmp106_;
		const gchar* _tmp107_;
		gint _tmp108_;
		gint _tmp109_;
		gint _tmp110_;
		ValadocGtkdocToken* _tmp111_;
		ValadocGtkdocToken* _tmp112_;
		_tmp100_ = id_start;
		_tmp101_ = id_len;
		_tmp102_ = string_substring (_tmp100_, (glong) 0, (glong) _tmp101_);
		_tmp103_ = _tmp102_;
		_tmp104_ = map;
		_tmp105_ = start;
		_tmp106_ = self->priv->pos;
		_tmp107_ = start;
		_tmp108_ = self->priv->line;
		_tmp109_ = column_start;
		_tmp110_ = self->priv->column;
		_tmp111_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN, _tmp103_, _tmp104_, _tmp105_, valadoc_gtkdoc_scanner_offset (self, _tmp106_, _tmp107_), _tmp108_, _tmp109_, _tmp110_);
		_tmp112_ = _tmp111_;
		_g_free0 (_tmp103_);
		result = _tmp112_;
		_vala_map_unref0 (map);
		return result;
	}
	_vala_map_unref0 (map);
}


static ValadocGtkdocToken*
valadoc_gtkdoc_scanner_newline_prefix (ValadocGtkdocScanner* self)
{
	ValadocGtkdocToken* result = NULL;
	const gchar* start = NULL;
	const gchar* _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	if (valadoc_gtkdoc_scanner_get (self) != ((gunichar) '\n')) {
		result = NULL;
		return result;
	}
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	_tmp1_ = self->priv->line;
	self->priv->line = _tmp1_ + 1;
	self->priv->column = 0;
	{
		gunichar c = 0U;
		c = valadoc_gtkdoc_scanner_next_char (self);
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				gunichar _tmp4_;
				if (!_tmp2_) {
					c = valadoc_gtkdoc_scanner_next_char (self);
				}
				_tmp2_ = FALSE;
				_tmp4_ = c;
				if (_tmp4_ == ((gunichar) ' ')) {
					_tmp3_ = TRUE;
				} else {
					gunichar _tmp5_;
					_tmp5_ = c;
					_tmp3_ = _tmp5_ == ((gunichar) '\t');
				}
				if (!_tmp3_) {
					break;
				}
			}
		}
	}
	if (valadoc_gtkdoc_scanner_get (self) == ((gunichar) '\n')) {
		gint _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		ValadocGtkdocToken* _tmp13_;
		valadoc_gtkdoc_scanner_next_char (self);
		_tmp6_ = self->priv->line;
		self->priv->line = _tmp6_ + 1;
		self->priv->column = 0;
		_tmp7_ = start;
		_tmp8_ = self->priv->pos;
		_tmp9_ = start;
		_tmp10_ = self->priv->line;
		_tmp11_ = self->priv->column;
		_tmp12_ = self->priv->column;
		_tmp13_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAGRAPH, "\n\n", NULL, _tmp7_, valadoc_gtkdoc_scanner_offset (self, _tmp8_, _tmp9_), _tmp10_, _tmp11_, _tmp12_);
		result = _tmp13_;
		return result;
	} else {
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		ValadocGtkdocToken* _tmp20_;
		_tmp14_ = start;
		_tmp15_ = self->priv->pos;
		_tmp16_ = start;
		_tmp17_ = self->priv->line;
		_tmp18_ = self->priv->column;
		_tmp19_ = self->priv->column;
		_tmp20_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_NEWLINE, "\n", NULL, _tmp14_, valadoc_gtkdoc_scanner_offset (self, _tmp15_, _tmp16_), _tmp17_, _tmp18_, _tmp19_);
		result = _tmp20_;
		return result;
	}
}


static ValadocGtkdocToken*
valadoc_gtkdoc_scanner_eof_prefix (ValadocGtkdocScanner* self)
{
	ValadocGtkdocToken* result = NULL;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	ValadocGtkdocToken* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	if (valadoc_gtkdoc_scanner_get (self) != ((gunichar) '\0')) {
		result = NULL;
		return result;
	}
	_tmp0_ = self->priv->pos;
	_tmp1_ = self->priv->line;
	_tmp2_ = self->priv->column;
	_tmp3_ = self->priv->column;
	_tmp4_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_EOF, "", NULL, _tmp0_, 1, _tmp1_, _tmp2_, _tmp3_);
	result = _tmp4_;
	return result;
}


static ValadocGtkdocToken*
valadoc_gtkdoc_scanner_space_prefix (ValadocGtkdocScanner* self)
{
	ValadocGtkdocToken* result = NULL;
	const gchar* start = NULL;
	const gchar* _tmp0_;
	gint column_start = 0;
	gint _tmp1_;
	gint len = 0;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gint _tmp8_;
	const gchar* _tmp11_;
	gint _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	ValadocGtkdocToken* _tmp21_;
	ValadocGtkdocToken* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	_tmp1_ = self->priv->column;
	column_start = _tmp1_;
	{
		gunichar c = 0U;
		c = valadoc_gtkdoc_scanner_get (self);
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				gunichar _tmp4_;
				if (!_tmp2_) {
					c = valadoc_gtkdoc_scanner_next_char (self);
				}
				_tmp2_ = FALSE;
				_tmp4_ = c;
				if (_tmp4_ == ((gunichar) ' ')) {
					_tmp3_ = TRUE;
				} else {
					gunichar _tmp5_;
					_tmp5_ = c;
					_tmp3_ = _tmp5_ == ((gunichar) '\t');
				}
				if (!_tmp3_) {
					break;
				}
			}
		}
	}
	_tmp6_ = self->priv->pos;
	_tmp7_ = start;
	len = valadoc_gtkdoc_scanner_offset (self, _tmp6_, _tmp7_);
	_tmp8_ = len;
	if (_tmp8_ == 0) {
		gint _tmp9_;
		const gchar* _tmp10_;
		_tmp9_ = column_start;
		self->priv->column = _tmp9_;
		_tmp10_ = start;
		self->priv->pos = _tmp10_;
		result = NULL;
		return result;
	}
	_tmp11_ = start;
	_tmp12_ = len;
	_tmp13_ = string_substring (_tmp11_, (glong) 0, (glong) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = start;
	_tmp16_ = self->priv->pos;
	_tmp17_ = start;
	_tmp18_ = self->priv->line;
	_tmp19_ = column_start;
	_tmp20_ = self->priv->column;
	_tmp21_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_SPACE, _tmp14_, NULL, _tmp15_, valadoc_gtkdoc_scanner_offset (self, _tmp16_, _tmp17_), _tmp18_, _tmp19_, _tmp20_);
	_tmp22_ = _tmp21_;
	_g_free0 (_tmp14_);
	result = _tmp22_;
	return result;
}


static ValadocGtkdocToken*
valadoc_gtkdoc_scanner_word_prefix (ValadocGtkdocScanner* self)
{
	ValadocGtkdocToken* result = NULL;
	const gchar* start = NULL;
	const gchar* _tmp0_;
	gint column_start = 0;
	gint _tmp1_;
	gunichar c = 0U;
	gboolean _tmp2_ = FALSE;
	gunichar _tmp3_;
	gint len = 0;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gint _tmp19_;
	const gchar* _tmp22_;
	gint _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	ValadocGtkdocToken* _tmp34_;
	ValadocGtkdocToken* _tmp35_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	_tmp1_ = self->priv->column;
	column_start = _tmp1_;
	c = valadoc_gtkdoc_scanner_get (self);
	_tmp3_ = c;
	if (_tmp3_ == ((gunichar) '<')) {
		_tmp2_ = TRUE;
	} else {
		gunichar _tmp4_;
		_tmp4_ = c;
		_tmp2_ = _tmp4_ == ((gunichar) '@');
	}
	if (_tmp2_) {
		valadoc_gtkdoc_scanner_next_char (self);
	}
	{
		gboolean _tmp5_ = FALSE;
		c = valadoc_gtkdoc_scanner_get (self);
		_tmp5_ = TRUE;
		while (TRUE) {
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_ = FALSE;
			gunichar _tmp11_;
			if (!_tmp5_) {
				c = valadoc_gtkdoc_scanner_next_char (self);
			}
			_tmp5_ = FALSE;
			_tmp11_ = c;
			if (_tmp11_ != ((gunichar) ' ')) {
				gunichar _tmp12_;
				_tmp12_ = c;
				_tmp10_ = _tmp12_ != ((gunichar) '\t');
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				gunichar _tmp13_;
				_tmp13_ = c;
				_tmp9_ = _tmp13_ != ((gunichar) '\n');
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				gunichar _tmp14_;
				_tmp14_ = c;
				_tmp8_ = _tmp14_ != ((gunichar) '\0');
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				gunichar _tmp15_;
				_tmp15_ = c;
				_tmp7_ = _tmp15_ != ((gunichar) '<');
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				gunichar _tmp16_;
				_tmp16_ = c;
				_tmp6_ = _tmp16_ != ((gunichar) '@');
			} else {
				_tmp6_ = FALSE;
			}
			if (!_tmp6_) {
				break;
			}
		}
	}
	_tmp17_ = self->priv->pos;
	_tmp18_ = start;
	len = valadoc_gtkdoc_scanner_offset (self, _tmp17_, _tmp18_);
	_tmp19_ = len;
	if (_tmp19_ == 0) {
		gint _tmp20_;
		const gchar* _tmp21_;
		_tmp20_ = column_start;
		self->priv->column = _tmp20_;
		_tmp21_ = start;
		self->priv->pos = _tmp21_;
		result = NULL;
		return result;
	}
	_tmp22_ = start;
	_tmp23_ = len;
	_tmp24_ = string_substring (_tmp22_, (glong) 0, (glong) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = valadoc_gtkdoc_scanner_unescape (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = start;
	_tmp29_ = self->priv->pos;
	_tmp30_ = start;
	_tmp31_ = self->priv->line;
	_tmp32_ = column_start;
	_tmp33_ = self->priv->column;
	_tmp34_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_WORD, _tmp27_, NULL, _tmp28_, valadoc_gtkdoc_scanner_offset (self, _tmp29_, _tmp30_), _tmp31_, _tmp32_, _tmp33_);
	_tmp35_ = _tmp34_;
	_g_free0 (_tmp27_);
	_g_free0 (_tmp25_);
	result = _tmp35_;
	return result;
}


static ValadocGtkdocToken*
valadoc_gtkdoc_scanner_gtkdoc_source_open_prefix (ValadocGtkdocScanner* self)
{
	ValadocGtkdocToken* result = NULL;
	const gchar* _tmp0_;
	const gchar* start = NULL;
	const gchar* _tmp1_;
	gint column_start = 0;
	gint _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	ValadocGtkdocToken* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->pos;
	if (!g_str_has_prefix (_tmp0_, "|[")) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->pos;
	start = _tmp1_;
	_tmp2_ = self->priv->column;
	column_start = _tmp2_;
	valadoc_gtkdoc_scanner_next_char (self);
	valadoc_gtkdoc_scanner_next_char (self);
	_tmp3_ = start;
	_tmp4_ = self->priv->pos;
	_tmp5_ = start;
	_tmp6_ = self->priv->line;
	_tmp7_ = column_start;
	_tmp8_ = self->priv->column;
	_tmp9_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SOURCE_OPEN, "|[", NULL, _tmp3_, valadoc_gtkdoc_scanner_offset (self, _tmp4_, _tmp5_), _tmp6_, _tmp7_, _tmp8_);
	result = _tmp9_;
	return result;
}


static ValadocGtkdocToken*
valadoc_gtkdoc_scanner_gtkdoc_source_close_prefix (ValadocGtkdocScanner* self)
{
	ValadocGtkdocToken* result = NULL;
	const gchar* _tmp0_;
	const gchar* start = NULL;
	const gchar* _tmp1_;
	gint column_start = 0;
	gint _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	ValadocGtkdocToken* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->pos;
	if (!g_str_has_prefix (_tmp0_, "]|")) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->pos;
	start = _tmp1_;
	_tmp2_ = self->priv->column;
	column_start = _tmp2_;
	valadoc_gtkdoc_scanner_next_char (self);
	valadoc_gtkdoc_scanner_next_char (self);
	_tmp3_ = start;
	_tmp4_ = self->priv->pos;
	_tmp5_ = start;
	_tmp6_ = self->priv->line;
	_tmp7_ = column_start;
	_tmp8_ = self->priv->column;
	_tmp9_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SOURCE_CLOSE, "]|", NULL, _tmp3_, valadoc_gtkdoc_scanner_offset (self, _tmp4_, _tmp5_), _tmp6_, _tmp7_, _tmp8_);
	result = _tmp9_;
	return result;
}


static gpointer
_valadoc_gtkdoc_token_ref0 (gpointer self)
{
	return self ? valadoc_gtkdoc_token_ref (self) : NULL;
}


ValadocGtkdocToken*
valadoc_gtkdoc_scanner_next (ValadocGtkdocScanner* self)
{
	ValadocGtkdocToken* result = NULL;
	ValadocGtkdocToken* _tmp0_;
	ValadocGtkdocToken* token = NULL;
	ValadocGtkdocToken* _tmp3_;
	ValadocGtkdocToken* _tmp4_;
	ValadocGtkdocToken* _tmp5_;
	ValadocGtkdocToken* _tmp6_;
	ValadocGtkdocToken* _tmp7_;
	ValadocGtkdocToken* _tmp8_;
	ValadocGtkdocToken* _tmp9_;
	ValadocGtkdocToken* _tmp10_;
	ValadocGtkdocToken* _tmp11_;
	ValadocGtkdocToken* _tmp12_;
	ValadocGtkdocToken* _tmp13_;
	ValadocGtkdocToken* _tmp14_;
	ValadocGtkdocToken* _tmp15_;
	ValadocGtkdocToken* _tmp16_;
	ValadocGtkdocToken* _tmp17_;
	ValadocGtkdocToken* _tmp18_;
	ValadocGtkdocToken* _tmp19_;
	ValadocGtkdocToken* _tmp20_;
	ValadocGtkdocToken* _tmp21_;
	ValadocGtkdocToken* _tmp22_;
	ValadocGtkdocToken* _tmp23_;
	ValadocGtkdocToken* _tmp24_;
	ValadocGtkdocToken* _tmp25_;
	ValadocGtkdocToken* _tmp26_;
	ValadocGtkdocToken* _tmp27_;
	ValadocGtkdocToken* _tmp28_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->tmp_token;
	if (_tmp0_ != NULL) {
		ValadocGtkdocToken* tmp = NULL;
		ValadocGtkdocToken* _tmp1_;
		ValadocGtkdocToken* _tmp2_;
		_tmp1_ = self->priv->tmp_token;
		_tmp2_ = _valadoc_gtkdoc_token_ref0 (_tmp1_);
		tmp = _tmp2_;
		_valadoc_gtkdoc_token_unref0 (self->priv->tmp_token);
		self->priv->tmp_token = NULL;
		result = tmp;
		return result;
	}
	_tmp3_ = valadoc_gtkdoc_scanner_function_prefix (self);
	token = _tmp3_;
	_tmp4_ = token;
	if (_tmp4_ != NULL) {
		result = token;
		return result;
	}
	_tmp5_ = valadoc_gtkdoc_scanner_xml_prefix (self);
	_valadoc_gtkdoc_token_unref0 (token);
	token = _tmp5_;
	_tmp6_ = token;
	if (_tmp6_ != NULL) {
		result = token;
		return result;
	}
	_tmp7_ = valadoc_gtkdoc_scanner_gtkdoc_param_prefix (self);
	_valadoc_gtkdoc_token_unref0 (token);
	token = _tmp7_;
	_tmp8_ = token;
	if (_tmp8_ != NULL) {
		result = token;
		return result;
	}
	_tmp9_ = valadoc_gtkdoc_scanner_gtkdoc_const_prefix (self);
	_valadoc_gtkdoc_token_unref0 (token);
	token = _tmp9_;
	_tmp10_ = token;
	if (_tmp10_ != NULL) {
		result = token;
		return result;
	}
	_tmp11_ = valadoc_gtkdoc_scanner_gtkdoc_type_prefix (self);
	_valadoc_gtkdoc_token_unref0 (token);
	token = _tmp11_;
	_tmp12_ = token;
	if (_tmp12_ != NULL) {
		result = token;
		return result;
	}
	_tmp13_ = valadoc_gtkdoc_scanner_space_prefix (self);
	_valadoc_gtkdoc_token_unref0 (token);
	token = _tmp13_;
	_tmp14_ = token;
	if (_tmp14_ != NULL) {
		result = token;
		return result;
	}
	_tmp15_ = valadoc_gtkdoc_scanner_newline_prefix (self);
	_valadoc_gtkdoc_token_unref0 (token);
	token = _tmp15_;
	_tmp16_ = token;
	if (_tmp16_ != NULL) {
		result = token;
		return result;
	}
	_tmp17_ = valadoc_gtkdoc_scanner_gtkdoc_signal_prefix (self);
	_valadoc_gtkdoc_token_unref0 (token);
	token = _tmp17_;
	_tmp18_ = token;
	if (_tmp18_ != NULL) {
		result = token;
		return result;
	}
	_tmp19_ = valadoc_gtkdoc_scanner_gtkdoc_property_prefix (self);
	_valadoc_gtkdoc_token_unref0 (token);
	token = _tmp19_;
	_tmp20_ = token;
	if (_tmp20_ != NULL) {
		result = token;
		return result;
	}
	_tmp21_ = valadoc_gtkdoc_scanner_gtkdoc_source_open_prefix (self);
	_valadoc_gtkdoc_token_unref0 (token);
	token = _tmp21_;
	_tmp22_ = token;
	if (_tmp22_ != NULL) {
		result = token;
		return result;
	}
	_tmp23_ = valadoc_gtkdoc_scanner_gtkdoc_source_close_prefix (self);
	_valadoc_gtkdoc_token_unref0 (token);
	token = _tmp23_;
	_tmp24_ = token;
	if (_tmp24_ != NULL) {
		result = token;
		return result;
	}
	_tmp25_ = valadoc_gtkdoc_scanner_eof_prefix (self);
	_valadoc_gtkdoc_token_unref0 (token);
	token = _tmp25_;
	_tmp26_ = token;
	if (_tmp26_ != NULL) {
		result = token;
		return result;
	}
	_tmp27_ = valadoc_gtkdoc_scanner_word_prefix (self);
	_valadoc_gtkdoc_token_unref0 (token);
	token = _tmp27_;
	_tmp28_ = token;
	if (_tmp28_ != NULL) {
		result = token;
		return result;
	}
	g_assert_not_reached ();
	_valadoc_gtkdoc_token_unref0 (token);
}


static void
valadoc_gtkdoc_value_scanner_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
valadoc_gtkdoc_value_scanner_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		valadoc_gtkdoc_scanner_unref (value->data[0].v_pointer);
	}
}


static void
valadoc_gtkdoc_value_scanner_copy_value (const GValue* src_value,
                                         GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = valadoc_gtkdoc_scanner_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
valadoc_gtkdoc_value_scanner_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
valadoc_gtkdoc_value_scanner_collect_value (GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValadocGtkdocScanner * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = valadoc_gtkdoc_scanner_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
valadoc_gtkdoc_value_scanner_lcopy_value (const GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	ValadocGtkdocScanner ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = valadoc_gtkdoc_scanner_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec*
valadoc_gtkdoc_param_spec_scanner (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags)
{
	ValadocGtkdocParamSpecScanner* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALADOC_GTKDOC_TYPE_SCANNER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer
valadoc_gtkdoc_value_get_scanner (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALADOC_GTKDOC_TYPE_SCANNER), NULL);
	return value->data[0].v_pointer;
}


void
valadoc_gtkdoc_value_set_scanner (GValue* value,
                                  gpointer v_object)
{
	ValadocGtkdocScanner * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALADOC_GTKDOC_TYPE_SCANNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALADOC_GTKDOC_TYPE_SCANNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		valadoc_gtkdoc_scanner_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		valadoc_gtkdoc_scanner_unref (old);
	}
}


void
valadoc_gtkdoc_value_take_scanner (GValue* value,
                                   gpointer v_object)
{
	ValadocGtkdocScanner * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALADOC_GTKDOC_TYPE_SCANNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALADOC_GTKDOC_TYPE_SCANNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		valadoc_gtkdoc_scanner_unref (old);
	}
}


static void
valadoc_gtkdoc_scanner_class_init (ValadocGtkdocScannerClass * klass)
{
	valadoc_gtkdoc_scanner_parent_class = g_type_class_peek_parent (klass);
	((ValadocGtkdocScannerClass *) klass)->finalize = valadoc_gtkdoc_scanner_finalize;
	g_type_class_add_private (klass, sizeof (ValadocGtkdocScannerPrivate));
}


static void
valadoc_gtkdoc_scanner_instance_init (ValadocGtkdocScanner * self)
{
	self->priv = VALADOC_GTKDOC_SCANNER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void
valadoc_gtkdoc_scanner_finalize (ValadocGtkdocScanner * obj)
{
	ValadocGtkdocScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_GTKDOC_TYPE_SCANNER, ValadocGtkdocScanner);
	g_signal_handlers_destroy (self);
	_valadoc_gtkdoc_token_unref0 (self->priv->tmp_token);
}


GType
valadoc_gtkdoc_scanner_get_type (void)
{
	static volatile gsize valadoc_gtkdoc_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_gtkdoc_scanner_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { valadoc_gtkdoc_value_scanner_init, valadoc_gtkdoc_value_scanner_free_value, valadoc_gtkdoc_value_scanner_copy_value, valadoc_gtkdoc_value_scanner_peek_pointer, "p", valadoc_gtkdoc_value_scanner_collect_value, "p", valadoc_gtkdoc_value_scanner_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValadocGtkdocScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_gtkdoc_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocGtkdocScanner), 0, (GInstanceInitFunc) valadoc_gtkdoc_scanner_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType valadoc_gtkdoc_scanner_type_id;
		valadoc_gtkdoc_scanner_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValadocGtkdocScanner", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&valadoc_gtkdoc_scanner_type_id__volatile, valadoc_gtkdoc_scanner_type_id);
	}
	return valadoc_gtkdoc_scanner_type_id__volatile;
}


gpointer
valadoc_gtkdoc_scanner_ref (gpointer instance)
{
	ValadocGtkdocScanner * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void
valadoc_gtkdoc_scanner_unref (gpointer instance)
{
	ValadocGtkdocScanner * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALADOC_GTKDOC_SCANNER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



