/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.input.movie;

import java.net.URL;
import java.util.ArrayList;
import javax.media.ConfigureCompleteEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Duration;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaTimeSetEvent;
import javax.media.Processor;
import javax.media.RealizeCompleteEvent;
import javax.media.Renderer;
import javax.media.StartEvent;
import javax.media.StopEvent;
import javax.media.Time;
import javax.media.UnsupportedPlugInException;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import org.web3d.vrml.renderer.common.input.movie.AudioRenderer;
import org.web3d.vrml.renderer.common.input.movie.VideoRenderer;
import org.web3d.vrml.renderer.common.input.movie.VideoStreamHandler;

public class MovieDecoder
implements ControllerListener {
    public final int REALIZED = 1;
    public final int STARTED = 2;
    public final int REWOUND = 4;
    public final int TIMESET = 8;
    public final int ALLSTATES = 15;
    private Processor processor = null;
    private VideoRenderer videoRenderer;
    private VideoStreamHandler videoHandler;
    private int state = 0;
    private ControlThread controlThread;

    public MovieDecoder(VideoStreamHandler videoStreamHandler) {
        this.videoHandler = videoStreamHandler;
        this.controlThread = new ControlThread();
    }

    public void init(String string) {
        try {
            URL uRL = new URL(string);
            this.processor = Manager.createProcessor((URL)uRL);
            this.processor.addControllerListener((ControllerListener)this);
            this.processor.configure();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void start() {
        this.controlThread.add(new StartAction());
    }

    public void stop() {
        this.controlThread.add(new StopAction());
    }

    public void rewind() {
        this.controlThread.add(new RewindAction());
    }

    public void setRate(float f) {
        this.controlThread.add(new SetRateAction(f));
    }

    public synchronized void controllerUpdate(ControllerEvent controllerEvent) {
        if (controllerEvent instanceof ConfigureCompleteEvent) {
            this.setHandlers();
            this.processor.setContentDescriptor(null);
            this.processor.realize();
        } else if (controllerEvent instanceof RealizeCompleteEvent) {
            this.controlThread.setState(5);
            Time time = this.processor.getDuration();
            double d = time == Duration.DURATION_UNKNOWN || time == Duration.DURATION_UNBOUNDED ? -1.0 : time.getSeconds();
            this.videoHandler.videoStreamDuration(d);
            this.processor.prefetch();
        } else if (controllerEvent instanceof StartEvent) {
            this.controlThread.setState(2);
            this.controlThread.unsetState(4);
        } else if (controllerEvent instanceof StopEvent) {
            this.controlThread.unsetState(2);
        } else if (controllerEvent instanceof MediaTimeSetEvent) {
            this.controlThread.setState(8);
        }
    }

    private void setHandlers() {
        TrackControl[] trackControlArray = this.processor.getTrackControls();
        int n = trackControlArray.length;
        for (int i = 0; i < n; ++i) {
            Format format = trackControlArray[i].getFormat();
            try {
                if (format instanceof VideoFormat) {
                    this.videoRenderer = new VideoRenderer(this.videoHandler);
                    trackControlArray[i].setRenderer((Renderer)this.videoRenderer);
                    continue;
                }
                if (format instanceof AudioFormat) {
                    trackControlArray[i].setRenderer((Renderer)new AudioRenderer());
                    continue;
                }
                System.err.println("Unknown track type");
                continue;
            }
            catch (UnsupportedPlugInException unsupportedPlugInException) {
                System.err.println("Got exception " + (Object)((Object)unsupportedPlugInException));
            }
        }
    }

    public class ControlThread
    extends Thread {
        private ArrayList jobQueue = new ArrayList();
        private Object stateSemaphore = new Object();
        private static final int STATE_SEMAPHORE_TIMEOUT = 10000;
        private boolean finish = false;

        public ControlThread() {
            this.start();
        }

        public String stateString(int n) {
            String string = "[ ";
            if ((n & 1) > 0) {
                string = string + "REALIZED ";
            }
            if ((n & 2) > 0) {
                string = string + "STARTED ";
            }
            if ((n & 4) > 0) {
                string = string + "REWOUND ";
            }
            if ((n & 8) > 0) {
                string = string + "TIMESET ";
            }
            string = string + "]";
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Action action) {
            ArrayList arrayList = this.jobQueue;
            synchronized (arrayList) {
                this.jobQueue.add(action);
                this.jobQueue.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish() {
            ArrayList arrayList = this.jobQueue;
            synchronized (arrayList) {
                this.finish = true;
                this.jobQueue.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Action action;
                ArrayList arrayList = this.jobQueue;
                synchronized (arrayList) {
                    while (this.jobQueue.isEmpty() && !this.finish) {
                        try {
                            this.jobQueue.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    action = (Action)this.jobQueue.remove(0);
                }
                try {
                    action.run();
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
                break;
            }
        }

        public boolean waitForState(int n) {
            return this.waitForState(n, n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitForState(int n, int n2) {
            long l = System.currentTimeMillis();
            boolean bl = false;
            boolean bl2 = false;
            while (!bl) {
                Object object = this.stateSemaphore;
                synchronized (object) {
                    if ((MovieDecoder.this.state & n2) == n) {
                        bl = true;
                    } else {
                        try {
                            this.stateSemaphore.wait(10000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        long l2 = System.currentTimeMillis() - l;
                        if (l2 > 10000L && (MovieDecoder.this.state & n2) != n) {
                            bl = true;
                            bl2 = true;
                        }
                    }
                }
            }
            return !bl2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setState(int n) {
            Object object = this.stateSemaphore;
            synchronized (object) {
                MovieDecoder.this.state = MovieDecoder.this.state | n;
                this.stateSemaphore.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unsetState(int n) {
            Object object = this.stateSemaphore;
            synchronized (object) {
                MovieDecoder.this.state = MovieDecoder.this.state & 15 - n;
                this.stateSemaphore.notify();
            }
        }
    }

    public class SetRateAction
    implements Action {
        private float speed;

        public SetRateAction(float f) {
            this.speed = f;
        }

        public void run() {
            MovieDecoder.this.controlThread.waitForState(1);
            MovieDecoder.this.processor.setRate(this.speed);
        }
    }

    public class RewindAction
    implements Action {
        public void run() {
            MovieDecoder.this.controlThread.waitForState(1);
            if ((MovieDecoder.this.state & 4) > 0) {
                return;
            }
            MovieDecoder.this.videoRenderer.enableCallbacks(false);
            if ((MovieDecoder.this.state & 2) > 0) {
                MovieDecoder.this.processor.stop();
            }
            MovieDecoder.this.controlThread.waitForState(0, 2);
            MovieDecoder.this.controlThread.unsetState(8);
            Time time = MovieDecoder.this.processor.getDuration();
            MovieDecoder.this.processor.setMediaTime(time);
            MovieDecoder.this.controlThread.waitForState(8);
            MovieDecoder.this.processor.start();
            MovieDecoder.this.controlThread.waitForState(2);
            MovieDecoder.this.controlThread.waitForState(0, 2);
            MovieDecoder.this.processor.setMediaTime(new Time(0L));
            MovieDecoder.this.controlThread.waitForState(8);
            MovieDecoder.this.controlThread.setState(4);
            MovieDecoder.this.videoRenderer.enableCallbacks(true);
        }
    }

    public class StopAction
    implements Action {
        public void run() {
            MovieDecoder.this.processor.stop();
            MovieDecoder.this.controlThread.waitForState(0, 2);
        }
    }

    public class StartAction
    implements Action {
        public void run() {
            MovieDecoder.this.controlThread.waitForState(1);
            MovieDecoder.this.processor.start();
            MovieDecoder.this.controlThread.waitForState(2);
        }
    }

    public static interface Action {
        public void run();
    }
}

