/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.util.Enumeration;
import rene.gui.Global;
import rene.util.xml.XmlWriter;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.Count;
import rene.zirkel.dialogs.CircleEditDialog;
import rene.zirkel.dialogs.EditConditionals;
import rene.zirkel.expression.Expression;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.MyGraphics13;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.InsideObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PointonObject;
import rene.zirkel.structures.Coordinates;

public class PrimitiveCircleObject
extends ConstructionObject
implements PointonObject,
InsideObject {
    protected double X;
    protected double Y;
    protected double R;
    static Count N = new Count();
    boolean Partial = false;
    PointObject[] Dep;
    int NDep;
    PointObject M;
    boolean Filled = false;
    Expression Start = null;
    Expression End = null;
    double A1;
    double A2;
    double A;
    boolean Arc = true;

    public PrimitiveCircleObject(Construction construction, PointObject pointObject) {
        super(construction);
        this.setColor(this.ColorIndex);
        this.M = pointObject;
        this.Unit = Global.getParameter("unit.length", "");
    }

    public String getTag() {
        return "Circle";
    }

    public int getN() {
        return N.next();
    }

    public void paint(MyGraphics myGraphics, ZirkelCanvas zirkelCanvas) {
        if (!this.Valid || this.mustHide(zirkelCanvas)) {
            return;
        }
        double d2 = zirkelCanvas.col(this.X - this.R);
        double d3 = zirkelCanvas.col(this.X + this.R);
        double d4 = zirkelCanvas.row(this.Y + this.R);
        double d5 = zirkelCanvas.row(this.Y - this.R);
        double d6 = (d5 - d4) / 2.0;
        double d7 = 1.0 / Math.sqrt(2.0);
        double d8 = -d7;
        if (!zirkelCanvas.showHidden() && this.Dep != null && this.NDep > 0 && this.Partial && !this.hasRange()) {
            for (int i = 0; i < this.NDep; ++i) {
                String string;
                if (!this.Dep[i].valid() || this.Dep[i].mustHide(zirkelCanvas)) continue;
                double d9 = Math.atan2(this.Dep[i].getY() - this.Y, this.Dep[i].getX() - this.X);
                if (d9 < 0.0) {
                    d9 += Math.PI * 2;
                }
                double d10 = d9 / Math.PI * 180.0;
                if (this.visible(zirkelCanvas)) {
                    if (this.isStrongSelected() && myGraphics instanceof MyGraphics13) {
                        ((MyGraphics13)myGraphics).drawMarkerArc((d2 + d3) / 2.0, (d4 + d5) / 2.0, d6, d10 - 10.0, 20.0);
                    }
                    myGraphics.setColor(this);
                    myGraphics.drawCircleArc(d2 + d6, d4 + d6, d6, d10 - 10.0, 20.0, this);
                }
                if (i != 0 || (string = this.getDisplayText()).equals("")) continue;
                myGraphics.setLabelColor(this);
                this.DisplaysText = true;
                double d11 = Math.cos(d9 - 0.1);
                double d12 = Math.sin(d9 - 0.1);
                this.drawLabel(myGraphics, string, zirkelCanvas, this.X + d11 * this.R, this.Y + d12 * this.R, d12, -d11, this.XcOffset, this.YcOffset);
            }
        } else {
            if (this.hasRange()) {
                this.computeA1A2();
                if (this.visible(zirkelCanvas)) {
                    if (this.isStrongSelected() && myGraphics instanceof MyGraphics13) {
                        ((MyGraphics13)myGraphics).drawMarkerArc((d2 + d3) / 2.0, (d4 + d5) / 2.0, d6, this.A1 / Math.PI * 180.0, this.A / Math.PI * 180.0);
                    }
                    myGraphics.setColor(this);
                    if (this.Filled) {
                        myGraphics.fillArc(d2, d4, d3 - d2, d5 - d4, this.A1 / Math.PI * 180.0, this.A / Math.PI * 180.0, this.Selected || this.getColorType() != 2, this.getColorType() != 1, this.Arc, this);
                    } else if (this.visible(zirkelCanvas)) {
                        myGraphics.drawCircleArc(d2 + d6, d4 + d6, d6, this.A1 / Math.PI * 180.0, this.A / Math.PI * 180.0, this);
                    }
                }
                d7 = Math.cos(this.A1 + this.A / 2.0);
                d8 = Math.sin(this.A1 + this.A / 2.0);
            } else if (this.Filled) {
                if (this.visible(zirkelCanvas)) {
                    if (this.isStrongSelected() && myGraphics instanceof MyGraphics13) {
                        ((MyGraphics13)myGraphics).drawMarkerArc((d2 + d3) / 2.0, (d4 + d5) / 2.0, d6, 0.0, 360.0);
                    }
                    myGraphics.setColor(this);
                    myGraphics.fillOval(d2, d4, d3 - d2, d5 - d4, this.Indicated || this.Selected || this.getColorType() == 0, this.getColorType() != 1, this);
                }
            } else if (this.visible(zirkelCanvas)) {
                if (this.isStrongSelected() && myGraphics instanceof MyGraphics13) {
                    ((MyGraphics13)myGraphics).drawMarkerArc((d2 + d3) / 2.0, (d4 + d5) / 2.0, d6, 0.0, 360.0);
                }
                myGraphics.setColor(this);
                myGraphics.drawCircle(d2 + d6, d4 + d6, d6, this);
            }
            String string = this.getDisplayText();
            if (!string.equals("")) {
                myGraphics.setLabelColor(this);
                this.DisplaysText = true;
                this.drawLabel(myGraphics, string, zirkelCanvas, this.X + d7 * this.R, this.Y + d8 * this.R, -d7, d8, this.XcOffset, this.YcOffset);
            }
        }
    }

    public String getDisplayValue() {
        return "" + this.round(this.R, ZirkelCanvas.LengthsFactor);
    }

    public String getEquation() {
        return "(x" + this.helpDisplayNumber(false, -this.X) + ")^2+" + "(y" + this.helpDisplayNumber(false, -this.Y) + ")^2=" + this.helpDisplayNumber(true, this.R * this.R);
    }

    public boolean nearto(int n, int n2, ZirkelCanvas zirkelCanvas) {
        return this.nearto(n, n2, false, zirkelCanvas);
    }

    public boolean nearto(int n, int n2, boolean bl, ZirkelCanvas zirkelCanvas) {
        if (!this.displays(zirkelCanvas)) {
            return false;
        }
        double d2 = zirkelCanvas.x(n) - this.X;
        double d3 = zirkelCanvas.y(n2) - this.Y;
        if (!bl && this.Filled) {
            double d4 = Math.sqrt(d2 * d2 + d3 * d3);
            if (d4 < this.R) {
                this.Value = 0.0;
            }
            return d4 < this.R;
        }
        if (this.hasRange()) {
            this.computeA1A2();
            double d5 = Math.atan2(d3, d2);
            if (d5 < 0.0) {
                d5 += Math.PI * 2;
            }
            if ((d5 -= this.A1) < 0.0) {
                d5 += Math.PI * 2;
            }
            double d6 = Math.abs(Math.sqrt(d2 * d2 + d3 * d3) - this.R);
            if (d5 <= this.A + 0.01) {
                this.Value = Math.abs(zirkelCanvas.col(zirkelCanvas.minX() + d6) - zirkelCanvas.col(zirkelCanvas.minX()));
            }
            return this.Value < zirkelCanvas.selectionSize() && d5 <= this.A + 0.01;
        }
        if (!zirkelCanvas.showHidden() && this.NDep > 0 && this.Partial) {
            double d7 = Math.abs(Math.sqrt(d2 * d2 + d3 * d3) - this.R);
            this.Value = Math.abs(zirkelCanvas.col(zirkelCanvas.minX() + d7) - zirkelCanvas.col(zirkelCanvas.minX()));
            if (Math.abs(zirkelCanvas.col(zirkelCanvas.minX() + d7) - zirkelCanvas.col(zirkelCanvas.minX())) >= zirkelCanvas.selectionSize()) {
                return false;
            }
            d7 = 0.17453292519943295;
            double d8 = Math.atan2(d3, d2);
            if (d8 < 0.0) {
                d8 += Math.PI * 2;
            }
            for (int i = 0; i < this.NDep; ++i) {
                double d9;
                if (!this.Dep[i].valid() || this.Dep[i].mustHide(zirkelCanvas)) continue;
                double d10 = Math.atan2(this.Dep[i].getY() - this.Y, this.Dep[i].getX() - this.X);
                if (d10 < 0.0) {
                    d10 += Math.PI * 2;
                }
                if ((d9 = d8 - d10) > Math.PI * 2) {
                    d9 -= Math.PI * 2;
                }
                if (d9 < Math.PI * -2) {
                    d9 += Math.PI * 2;
                }
                if (!(Math.abs(d9) < d7)) continue;
                return true;
            }
            return false;
        }
        double d11 = Math.abs(Math.sqrt(d2 * d2 + d3 * d3) - this.R);
        this.Value = Math.abs(zirkelCanvas.col(zirkelCanvas.minX() + d11) - zirkelCanvas.col(zirkelCanvas.minX()));
        return Math.abs(zirkelCanvas.col(zirkelCanvas.minX() + d11) - zirkelCanvas.col(zirkelCanvas.minX())) < zirkelCanvas.selectionSize();
    }

    public boolean onlynearto(int n, int n2, ZirkelCanvas zirkelCanvas) {
        if (this.R < zirkelCanvas.dx(3 * (int)zirkelCanvas.pointSize())) {
            return true;
        }
        if (this.hasRange()) {
            double d2;
            double d3;
            double d4 = Math.atan2(this.getStart().getY() - this.Y, this.getStart().getX() - this.X);
            if (d4 < 0.0) {
                d4 += Math.PI * 2;
            }
            if ((d3 = Math.atan2(this.getEnd().getY() - this.Y, this.getEnd().getX() - this.X)) < 0.0) {
                d3 += Math.PI * 2;
            }
            if ((d2 = d3 - d4) >= Math.PI * 2) {
                d2 -= Math.PI * 2;
            }
            if (d2 < 0.0) {
                d2 += Math.PI * 2;
            }
            if (!this.Obtuse && d2 > Math.PI) {
                d4 = d3;
                d2 = Math.PI * 2 - d2;
                d3 = d4 + d2;
            }
            if (d2 * this.R < zirkelCanvas.dx(6 * (int)zirkelCanvas.pointSize())) {
                return true;
            }
        }
        return false;
    }

    public double getX() {
        return this.X;
    }

    public double getY() {
        return this.Y;
    }

    public double getR() {
        return this.R;
    }

    public static Coordinates intersect(PrimitiveCircleObject primitiveCircleObject, PrimitiveCircleObject primitiveCircleObject2) {
        double d2 = primitiveCircleObject2.X - primitiveCircleObject.X;
        double d3 = primitiveCircleObject2.Y - primitiveCircleObject.Y;
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        if (d4 > primitiveCircleObject.R + primitiveCircleObject2.R + 1.0E-10) {
            return null;
        }
        if (d4 <= 1.0E-10) {
            return new Coordinates(primitiveCircleObject.X, primitiveCircleObject.Y, primitiveCircleObject.X, primitiveCircleObject.Y);
        }
        double d5 = (d4 * d4 + primitiveCircleObject.R * primitiveCircleObject.R - primitiveCircleObject2.R * primitiveCircleObject2.R) / (2.0 * d4);
        double d6 = primitiveCircleObject.X + d5 * (d2 /= d4);
        double d7 = primitiveCircleObject.Y + d5 * (d3 /= d4);
        double d8 = primitiveCircleObject.R * primitiveCircleObject.R - d5 * d5;
        if (d8 < -1.0E-10) {
            return null;
        }
        d8 = d8 < 0.0 ? 0.0 : Math.sqrt(d8);
        return new Coordinates(d6 + d8 * d3, d7 - d8 * d2, d6 - d8 * d3, d7 + d8 * d2);
    }

    public void edit(ZirkelCanvas zirkelCanvas) {
        CircleEditDialog circleEditDialog = new CircleEditDialog(zirkelCanvas.getFrame(), this, zirkelCanvas);
        circleEditDialog.setVisible(true);
        zirkelCanvas.getConstruction().updateCircleDep();
        zirkelCanvas.validate();
        zirkelCanvas.repaint();
        if (circleEditDialog.wantsMore()) {
            new EditConditionals(zirkelCanvas.getFrame(), this);
            this.validate();
        }
    }

    public boolean equals(ConstructionObject constructionObject) {
        if (!(constructionObject instanceof PrimitiveCircleObject) || !constructionObject.valid()) {
            return false;
        }
        PrimitiveCircleObject primitiveCircleObject = (PrimitiveCircleObject)constructionObject;
        return this.equals(this.X, primitiveCircleObject.X) && this.equals(this.Y, primitiveCircleObject.Y) && this.equals(this.R, primitiveCircleObject.R);
    }

    public void setPartial(boolean bl) {
        if (bl == this.Partial) {
            return;
        }
        this.Partial = bl;
        if (bl) {
            this.Dep = new PointObject[16];
            this.NDep = 0;
        } else {
            this.Dep = null;
        }
    }

    public void addDep(PointObject pointObject) {
        if (!this.Partial || this.hasRange() || this.Dep == null || this.NDep >= this.Dep.length) {
            return;
        }
        this.Dep[this.NDep++] = pointObject;
    }

    public void clearCircleDep() {
        this.NDep = 0;
    }

    public boolean isPartial() {
        return this.Partial;
    }

    public void printArgs(XmlWriter xmlWriter) {
        xmlWriter.printArg("midpoint", this.M.getName());
        if (this.Partial) {
            xmlWriter.printArg("partial", "true");
        }
        if (this.Filled) {
            xmlWriter.printArg("filled", "true");
        }
        if (this.getStart() != null) {
            xmlWriter.printArg("start", this.getStart().getName());
        }
        if (this.getEnd() != null) {
            xmlWriter.printArg("end", this.getEnd().getName());
        }
        if (!this.Obtuse) {
            xmlWriter.printArg("acute", "true");
        }
        if (!this.Arc) {
            xmlWriter.printArg("chord", "true");
        }
        super.printArgs(xmlWriter);
    }

    public ConstructionObject copy() {
        PrimitiveCircleObject primitiveCircleObject = (PrimitiveCircleObject)super.copy();
        if (primitiveCircleObject.Partial) {
            primitiveCircleObject.Dep = new PointObject[16];
            primitiveCircleObject.NDep = 0;
        } else {
            primitiveCircleObject.Dep = null;
        }
        return primitiveCircleObject;
    }

    public void setDefaults() {
        super.setDefaults();
        this.setPartial(this.Cn.Partial);
    }

    public Enumeration depending() {
        super.depending();
        DL.add(this.M);
        return DL.elements();
    }

    public Enumeration secondaryParams() {
        DL.reset();
        return this.depset(this.M);
    }

    public void toggleHidden() {
        if (this.Hidden) {
            this.Hidden = false;
        } else if (this.Partial) {
            this.setPartial(false);
            this.Hidden = true;
        } else {
            this.setPartial(true);
        }
    }

    public PointObject getP1() {
        return this.M;
    }

    public void setFilled(boolean bl) {
        this.Filled = bl;
    }

    public boolean isFilled() {
        return this.Filled;
    }

    public boolean isFilledForSelect() {
        return this.Filled;
    }

    public void translate() {
        this.M = (PointObject)this.M.getTranslation();
        if (this.hasRange()) {
            this.setRange(this.getStart().getName(), this.getEnd().getName());
            this.Start.translate();
            this.End.translate();
        }
    }

    public boolean setRange(String string, String string2) {
        try {
            this.Start = new Expression("@\"" + string + "\"", this.Cn, this);
            this.End = new Expression("@\"" + string2 + "\"", this.Cn, this);
            return this.hasRange();
        }
        catch (Exception exception) {
            this.End = null;
            this.Start = null;
            return false;
        }
    }

    public PointObject getStart() {
        return PrimitiveCircleObject.getPointObject(this.Start);
    }

    public PointObject getEnd() {
        return PrimitiveCircleObject.getPointObject(this.End);
    }

    public String getStartString() {
        String string = "";
        if (this.Start != null) {
            string = this.Start.toString();
        }
        if (string.startsWith("@")) {
            string = string.substring(1);
        }
        return string;
    }

    public String getEndString() {
        String string = "";
        if (this.End != null) {
            string = this.End.toString();
        }
        if (string.startsWith("@")) {
            string = string.substring(1);
        }
        return string;
    }

    public double getA1() {
        return this.A1;
    }

    public double getA2() {
        return this.A2;
    }

    public boolean hasRange() {
        return this.getStart() != null && this.getEnd() != null;
    }

    public void clearRange() {
        this.End = null;
        this.Start = null;
    }

    public boolean maybeTransparent() {
        return true;
    }

    public boolean locallyLike(ConstructionObject constructionObject) {
        if (!(constructionObject instanceof PrimitiveCircleObject)) {
            return false;
        }
        return this.equals(this.X, ((PrimitiveCircleObject)constructionObject).X) && this.equals(this.Y, ((PrimitiveCircleObject)constructionObject).Y) && this.equals(this.R, ((PrimitiveCircleObject)constructionObject).R);
    }

    public boolean getArc() {
        return this.Arc;
    }

    public void setArc(boolean bl) {
        this.Arc = bl;
    }

    public void computeA1A2() {
        this.A1 = Math.atan2(this.getStart().getY() - this.Y, this.getStart().getX() - this.X);
        if (this.A1 < 0.0) {
            this.A1 += Math.PI * 2;
        }
        this.A2 = Math.atan2(this.getEnd().getY() - this.Y, this.getEnd().getX() - this.X);
        if (this.A2 < 0.0) {
            this.A2 += Math.PI * 2;
        }
        if (this.A2 < this.A1) {
            this.A2 += Math.PI * 2;
        }
        this.A = this.A2 - this.A1;
        if (!this.Obtuse && this.A > 3.141592653689793) {
            this.A1 = this.A2;
            if (this.A1 >= Math.PI * 2) {
                this.A1 -= Math.PI * 2;
            }
            this.A = Math.PI * 2 - this.A;
            this.A2 = this.A1 + this.A;
        }
        if (this.Partial) {
            this.A1 -= 0.17453292519943295;
            this.A += 0.3490658503988659;
        }
    }

    public boolean contains(double d2, double d3) {
        double d4;
        if (!this.hasRange()) {
            return true;
        }
        this.computeA1A2();
        double d5 = Math.atan2(d3 - this.Y, d2 - this.X);
        if (d5 < 0.0) {
            d5 += Math.PI * 2;
        }
        if ((d4 = d5 - this.A1) < 0.0) {
            d4 += Math.PI * 2;
        }
        return d4 < this.A + 1.0E-4;
    }

    public void project(PointObject pointObject) {
        double d2 = pointObject.getX() - this.getX();
        double d3 = pointObject.getY() - this.getY();
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        double d5 = 0.0;
        double d6 = 0.0;
        if (d4 < 1.0E-10) {
            d5 = this.getX() + this.getR();
            d6 = this.getY();
        } else {
            d5 = this.getX() + d2 / d4 * this.getR();
            d6 = this.getY() + d3 / d4 * this.getR();
        }
        double d7 = Math.atan2(pointObject.getY() - this.getY(), pointObject.getX() - this.getX());
        if (this.hasRange() && this.getStart() != pointObject && this.getEnd() != pointObject) {
            if (d7 < 0.0) {
                d7 += Math.PI * 2;
            }
            this.computeA1A2();
            double d8 = this.getA1();
            double d9 = this.getA2();
            if (d7 < d8) {
                d7 += Math.PI * 2;
            }
            if (d7 > d9) {
                d7 = Math.PI * 2 - (d7 - d8) < d7 - d9 ? d8 : d9;
            }
            d5 = this.getX() + this.getR() * Math.cos(d7);
            d6 = this.getY() + this.getR() * Math.sin(d7);
        }
        pointObject.setXY(d5, d6);
        pointObject.setA(d7);
    }

    public void project(PointObject pointObject, double d2) {
        double d3 = pointObject.getX() - this.getX();
        double d4 = pointObject.getY() - this.getY();
        double d5 = Math.sqrt(d3 * d3 + d4 * d4);
        double d6 = 0.0;
        double d7 = 0.0;
        if (d5 < 1.0E-10) {
            d6 = this.getX() + this.getR();
            d7 = this.getY();
        } else {
            d6 = this.getX() + d3 / d5 * this.getR();
            d7 = this.getY() + d4 / d5 * this.getR();
        }
        if (this.hasRange() && this.getStart() != pointObject && this.getEnd() != pointObject) {
            double d8 = pointObject.getAlpha();
            if (d8 < 0.0) {
                d8 += Math.PI * 2;
            }
            if (d8 >= Math.PI * 2) {
                d8 -= Math.PI * 2;
            }
            this.computeA1A2();
            double d9 = this.getA1();
            double d10 = this.getA2();
            if (d8 < d9) {
                d8 += Math.PI * 2;
            }
            if (d8 > d10) {
                d8 = Math.PI * 2 - (d8 - d9) < d8 - d10 ? d9 : d10;
            }
            pointObject.setA(d8);
            d6 = this.getX() + this.getR() * Math.cos(d8);
            d7 = this.getY() + this.getR() * Math.sin(d8);
        } else {
            d6 = this.getX() + this.getR() * Math.cos(d2);
            d7 = this.getY() + this.getR() * Math.sin(d2);
        }
        pointObject.setXY(d6, d7);
    }

    public double containsInside(PointObject pointObject) {
        double d2;
        double d3 = pointObject.getX() - this.X;
        double d4 = Math.sqrt(d3 * d3 + (d2 = pointObject.getY() - this.Y) * d2);
        if (d4 < this.R * 0.9999999999) {
            return 1.0;
        }
        if (d4 < this.R * 1.0000000001) {
            return 0.5;
        }
        return 0.0;
    }

    public boolean keepInside(PointObject pointObject) {
        double d2 = pointObject.getX() - this.X;
        double d3 = pointObject.getY() - this.Y;
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        double d5 = 1.0;
        if (this.Filled && this.ColorType == 2) {
            d5 = 0.9999;
        }
        if (d4 < this.R * d5 || this.R < 1.0E-10) {
            return true;
        }
        pointObject.setXY(this.X + d2 / d4 * (this.R * d5), this.Y + d3 / d4 * (this.R * d5));
        return false;
    }

    public boolean canInteresectWith(ConstructionObject constructionObject) {
        return true;
    }
}

