/*******************************************************************************
 * Copyright (C) 2004-2007 Intel Corp. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *   - Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 * 
 *   - Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the documentation
 *     and/or other materials provided with the distribution.
 * 
 *   - Neither the name of Intel Corp. nor the names of its
 *     contributors may be used to endorse or promote products derived from this
 *     software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL Intel Corp. OR THE CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *******************************************************************************/

#ifndef __HECI_H__
#define __HECI_H__

#include <memory.h>
#include <stdint.h>

#ifndef GUID_DEFINED
#define GUID_DEFINED

#pragma pack(push,1)
typedef struct guid
{
  uint32_t  data1;
  uint16_t  data2;
  uint16_t  data3;
  uint8_t   data4[8];
} GUID;
#pragma pack(pop)
#endif

class HECI {
public:
	HECI(const GUID guid, bool verbose = false): _initialized(false), _verbose(verbose), _bufSize(0) {
		memcpy(&_guid, &guid, sizeof(_guid));
	}
	virtual ~HECI() {}

	virtual bool Init() = 0;
	virtual void Deinit() = 0;
	virtual int ReceiveMessage(unsigned char *buffer, int len, unsigned long timeout = 2000) = 0;
	virtual int SendMessage(unsigned char *buffer, int len, unsigned long timeout = 2000) = 0;
	virtual unsigned long GetBufferSize() = 0;

protected:
	GUID _guid;
	bool _initialized;
	bool _verbose;
	unsigned long _bufSize;
};

#endif
